/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.AuthHelper;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class PingCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)PingCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String sessionId = webSocketData.getSessionId();
        logger.debug("PING received from session {}", (Object)sessionId);
        Principal currentUser = AuthHelper.getPrincipalForSessionId((String)sessionId);
        if (currentUser != null) {
            this.getWebSocket().send(MessageBuilder.status().callback(webSocketData.getCallback()).data("username", currentUser.getProperty((PropertyKey)AbstractNode.name)).data("isAdmin", currentUser.getProperty((PropertyKey)Principal.isAdmin)).code(100).build(), true);
        } else {
            logger.debug("Invalid session id");
            this.getWebSocket().send(MessageBuilder.status().code(401).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "PING";
    }

    static {
        StructrWebSocket.addCommand(PingCommand.class);
    }
}

