/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.web.diff.InvertibleModificationOperation;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.importer.Importer;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SaveNodeCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SaveNodeCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String nodeId = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String modifiedHtml = (String)nodeData.get("source");
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Page modifiedNode = null;
        DOMNode sourceNode = (DOMNode)this.getNode(nodeId);
        if (sourceNode != null) {
            TransactionCommand.registerNodeCallback((NodeInterface)sourceNode, (String)this.callback);
            try {
                DOMNode targetNode = modifiedNode = Importer.parsePageFromSource(securityContext, modifiedHtml, "__SaveNodeCommand_Temporary_Page__");
                if (!(sourceNode instanceof Page)) {
                    targetNode = (DOMNode)modifiedNode.getFirstChild().getNextSibling().getFirstChild().getNextSibling().getFirstChild();
                }
                List<InvertibleModificationOperation> changeSet = Importer.diffNodes(sourceNode, targetNode);
                for (InvertibleModificationOperation op : changeSet) {
                    op.apply(app, sourceNode.getClosestPage(), modifiedNode);
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
                this.getWebSocket().send(MessageBuilder.status().code(422).message(t.toString()).build(), true);
            }
            try {
                app.delete((NodeInterface)modifiedNode);
            }
            catch (FrameworkException ex) {
                logger.warn("", (Throwable)ex);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot save page").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "SAVE_NODE";
    }

    static {
        StructrWebSocket.addCommand(SaveNodeCommand.class);
    }
}

