/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.schema.SchemaHelper;
import org.structr.web.common.RenderContext;
import org.structr.web.datasource.RestDataSource;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SearchCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SearchCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String searchString = (String)webSocketData.getNodeData().get("searchString");
        Boolean exactSearch = (Boolean)webSocketData.getNodeData().get("exact");
        String restQuery = (String)webSocketData.getNodeData().get("restQuery");
        String cypherQuery = (String)webSocketData.getNodeData().get("cypherQuery");
        String paramString = (String)webSocketData.getNodeData().get("cypherParams");
        String typeString = (String)webSocketData.getNodeData().get("type");
        int pageSize = webSocketData.getPageSize();
        int page = webSocketData.getPage();
        Class type = null;
        if (typeString != null) {
            type = SchemaHelper.getEntityClassForRawType((String)typeString);
        }
        if (searchString == null) {
            if (cypherQuery != null) {
                try {
                    Map obj = null;
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{paramString})) {
                        obj = (Map)new Gson().fromJson(paramString, Map.class);
                    }
                    List result = StructrApp.getInstance((SecurityContext)securityContext).cypher(cypherQuery, obj);
                    int resultCountBeforePaging = result.size();
                    webSocketData.setRawResultCount(resultCountBeforePaging);
                    if (page != 0 && pageSize != 0) {
                        webSocketData.setResult(result.subList((page - 1) * pageSize, Math.min(page * pageSize, resultCountBeforePaging)));
                    } else {
                        webSocketData.setResult(result);
                    }
                    this.getWebSocket().send(webSocketData, true);
                    return;
                }
                catch (Exception ex) {
                    logger.warn("Exception occured", (Throwable)ex);
                    this.getWebSocket().send(MessageBuilder.status().code(400).message(ex.getMessage()).build(), true);
                    return;
                }
            }
            if (restQuery != null) {
                RestDataSource restDataSource = new RestDataSource();
                try {
                    securityContext.setRequest(this.getWebSocket().getRequest());
                    webSocketData.setResult(restDataSource.getData(new RenderContext(securityContext), restQuery));
                    this.getWebSocket().send(webSocketData, true);
                    return;
                }
                catch (FrameworkException ex) {
                    logger.error("", (Throwable)ex);
                    return;
                }
            }
        }
        String sortOrder = webSocketData.getSortOrder();
        String sortKey = webSocketData.getSortKey();
        PropertyKey sortProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(AbstractNode.class, sortKey);
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery().includeDeletedAndHidden().sort(sortProperty).order("desc".equals(sortOrder));
        query.and((PropertyKey)AbstractNode.name, (Object)searchString, exactSearch.booleanValue());
        if (type != null) {
            query.andType(type);
        }
        try {
            Result result = query.getResult();
            webSocketData.setResult(result.getResults());
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "SEARCH";
    }

    static {
        StructrWebSocket.addCommand(SearchCommand.class);
    }
}

