/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class CreateDOMNodeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String pageId = webSocketData.getPageId();
        if (pageId != null) {
            Page document = this.getPage(pageId);
            if (document != null) {
                String tagName = (String)nodeData.get("tagName");
                if (tagName != null && !tagName.isEmpty()) {
                    document.createElement(tagName);
                } else {
                    document.createTextNode("");
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Page not found").build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot create node without pageId").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_DOM_NODE";
    }

    static {
        StructrWebSocket.addCommand(CreateDOMNodeCommand.class);
    }
}

