/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class ReplaceDOMNodeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        String newId = (String)nodeData.get("newId");
        String oldId = (String)nodeData.get("oldId");
        String pageId = webSocketData.getPageId();
        if (pageId != null) {
            if (parentId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot replace node without parentId").build(), true);
                return;
            }
            DOMNode parentNode = this.getDOMNode(parentId);
            if (parentNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
                return;
            }
            if (oldId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot replace node without oldId").build(), true);
                return;
            }
            DOMNode oldNode = this.getDOMNode(oldId);
            if (oldNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("Old node not found").build(), true);
                return;
            }
            if (newId == null) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot replace node without newId").build(), true);
                return;
            }
            DOMNode newNode = this.getDOMNode(newId);
            if (newNode == null) {
                this.getWebSocket().send(MessageBuilder.status().code(404).message("New node not found").build(), true);
                return;
            }
            try {
                parentNode.replaceChild(newNode, oldNode);
            }
            catch (DOMException dex) {
                this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot replace node without pageId").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "REPLACE_DOM_NODE";
    }

    static {
        StructrWebSocket.addCommand(ReplaceDOMNodeCommand.class);
    }
}

