/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.Template;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class WrapDOMNodeCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)WrapDOMNodeCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        block19: {
            Map<String, Object> nodeData = webSocketData.getNodeData();
            String pageId = webSocketData.getPageId();
            String nodeId = (String)nodeData.get("nodeId");
            Boolean inheritVisibilityFlags = (Boolean)nodeData.get("inheritVisibilityFlags");
            nodeData.remove("nodeId");
            nodeData.remove("inheritVisibilityFlags");
            if (pageId != null) {
                if (nodeId == null) {
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot wrap node without nodeId").build(), true);
                    return;
                }
                DOMNode oldNode = this.getDOMNode(nodeId);
                if (oldNode == null) {
                    this.getWebSocket().send(MessageBuilder.status().code(404).message("Node not found").build(), true);
                    return;
                }
                Page document = this.getPage(pageId);
                if (document != null) {
                    String tagName = (String)nodeData.get("tagName");
                    nodeData.remove("tagName");
                    DOMNode parentNode = (DOMNode)oldNode.getParentNode();
                    if (parentNode == null) {
                        this.getWebSocket().send(MessageBuilder.status().code(404).message("Node has no parent node").build(), true);
                        return;
                    }
                    try {
                        DOMNode newNode;
                        if (tagName != null && "comment".equals(tagName)) {
                            newNode = (DOMNode)((Object)document.createComment("#comment"));
                        } else if (tagName != null && "template".equals(tagName)) {
                            newNode = (DOMNode)((Object)document.createTextNode("#template"));
                            try {
                                newNode.unlockSystemPropertiesOnce();
                                newNode.setProperties(newNode.getSecurityContext(), new PropertyMap((PropertyKey)NodeInterface.type, (Object)Template.class.getSimpleName()));
                            }
                            catch (FrameworkException fex) {
                                logger.warn("Unable to set type of node {} to Template: {}", new Object[]{newNode.getUuid(), fex.getMessage()});
                            }
                        } else if (tagName != null && !tagName.isEmpty()) {
                            newNode = (DOMNode)((Object)document.createElement(tagName));
                        } else {
                            this.getWebSocket().send(MessageBuilder.status().code(404).message("Cannot create node without tagname").build(), true);
                            return;
                        }
                        newNode = this.getDOMNode(newNode.getUuid());
                        if (newNode == null) break block19;
                        parentNode.replaceChild(newNode, oldNode);
                        newNode.appendChild(oldNode);
                        if (!inheritVisibilityFlags.booleanValue()) break block19;
                        PropertyMap visibilityFlags = new PropertyMap();
                        visibilityFlags.put((PropertyKey)DOMNode.visibleToAuthenticatedUsers, parentNode.getProperty((PropertyKey)DOMNode.visibleToAuthenticatedUsers));
                        visibilityFlags.put((PropertyKey)DOMNode.visibleToPublicUsers, parentNode.getProperty((PropertyKey)DOMNode.visibleToPublicUsers));
                        try {
                            newNode.setProperties(newNode.getSecurityContext(), visibilityFlags);
                        }
                        catch (FrameworkException fex) {
                            logger.warn("Unable to inherit visibility flags for node {} from parent node {}", (Object)newNode, (Object)parentNode);
                        }
                    }
                    catch (DOMException dex) {
                        this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
                    }
                } else {
                    this.getWebSocket().send(MessageBuilder.status().code(404).message("Page not found").build(), true);
                }
            } else {
                this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot wrap node without pageId").build(), true);
            }
        }
    }

    @Override
    public String getCommand() {
        return "WRAP_DOM_NODE";
    }

    static {
        StructrWebSocket.addCommand(WrapDOMNodeCommand.class);
    }
}

