/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.message;

import com.google.gson.JsonElement;
import java.util.Map;
import org.structr.websocket.message.WebSocketMessage;

public class MessageBuilder {
    private WebSocketMessage data = new WebSocketMessage();

    public static MessageBuilder progress() {
        return MessageBuilder.builder().command("PROGRESS");
    }

    public static MessageBuilder finished() {
        return MessageBuilder.builder().command("FINISHED");
    }

    public static MessageBuilder status() {
        return MessageBuilder.builder().command("STATUS");
    }

    public static MessageBuilder create() {
        return MessageBuilder.builder().command("CREATE");
    }

    public static MessageBuilder delete() {
        return MessageBuilder.builder().command("DELETE");
    }

    public static MessageBuilder update() {
        return MessageBuilder.builder().command("UPDATE");
    }

    public static MessageBuilder wrappedRest() {
        return MessageBuilder.builder().command("WRAPPED_REST");
    }

    public static MessageBuilder forName(String command) {
        return MessageBuilder.builder().command(command);
    }

    public MessageBuilder command(String command) {
        this.data.setCommand(command);
        return this;
    }

    public MessageBuilder code(int code) {
        this.data.setCode(code);
        return this;
    }

    public MessageBuilder id(String id) {
        this.data.setId(id);
        return this;
    }

    public MessageBuilder message(String message) {
        this.data.setMessage(message);
        return this;
    }

    public MessageBuilder callback(String callback) {
        if (callback != null) {
            this.data.setCallback(callback);
        }
        return this;
    }

    public MessageBuilder data(String key, Object value) {
        this.data.setNodeData(key, value);
        return this;
    }

    public MessageBuilder data(Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            this.data.setNodeData(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public MessageBuilder jsonErrorObject(JsonElement error) {
        this.data.setJsonErrorObject(error);
        return this;
    }

    public WebSocketMessage build() {
        return this.data;
    }

    private static MessageBuilder builder() {
        return new MessageBuilder();
    }
}

