/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class CharPtr
implements Ptr {
    public static final CharPtr NULL = new CharPtr();
    public final char[] array;
    public final int offset;

    private CharPtr() {
        this.array = null;
        this.offset = 0;
    }

    public CharPtr(char[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public CharPtr(char ... array) {
        this.array = array;
        this.offset = 0;
    }

    public char[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public CharPtr realloc(int newSizeInBytes) {
        return new CharPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 2));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new CharPtr(this.array, this.offset + bytes / 2);
    }

    public static CharPtr fromString(String string) {
        int nchars = string.length();
        char[] array = new char[nchars + 1];
        System.arraycopy(string.toCharArray(), 0, array, 0, nchars);
        return new CharPtr(array);
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public String asString() {
        int length;
        for (length = this.offset; length < this.array.length && this.array[length] != '\u0000'; ++length) {
        }
        return new String(this.array, this.offset, length - this.offset);
    }

    public static CharPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).charPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (CharPtr)voidPointer;
    }

    public static void memset(char[] array, int offset, int value, int length) {
        throw new UnsupportedOperationException("TODO");
    }

    public static char memset(int byteValue) {
        throw new UnsupportedOperationException("TODO");
    }
}

