/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class LongPtr
implements Ptr {
    public static final LongPtr NULL = new LongPtr();
    public final long[] array;
    public final int offset;

    private LongPtr() {
        this.array = null;
        this.offset = 0;
    }

    public LongPtr(long[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public LongPtr(long ... array) {
        this.array = array;
        this.offset = 0;
    }

    public long[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public LongPtr realloc(int newSizeInBytes) {
        return new LongPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 8));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new LongPtr(this.array, this.offset + bytes / 8);
    }

    public long unwrap() {
        return this.array[this.offset];
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static int memcmp(LongPtr x, LongPtr y, int n) {
        return LongPtr.memcmp(x.array, x.offset, y.array, y.offset, n);
    }

    public static int memcmp(long[] x, int xi, long[] y, int yi, int n) {
        while (n > 0) {
            long vx = x[xi];
            long vy = y[yi];
            if (vx != vy || n < 8) {
                return LongPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static int memcmp(long x, long y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)(x & 0xFFL);
            int yb = (int)(y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c, int n) {
        assert (n % 64 == 0);
        Arrays.fill(str, strOffset, strOffset + c / 64, (double)LongPtr.memset(c));
    }

    public static long memset(int c) {
        return ((long)c & 0xFFL) << 56 | ((long)c & 0xFFL) << 48 | ((long)c & 0xFFL) << 40 | ((long)c & 0xFFL) << 32 | ((long)c & 0xFFL) << 24 | ((long)c & 0xFFL) << 16 | ((long)c & 0xFFL) << 8 | (long)c & 0xFFL;
    }

    public static LongPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).longPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (LongPtr)voidPointer;
    }
}

