/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class ShortPtr
implements Ptr {
    public static final ShortPtr NULL = new ShortPtr();
    public final short[] array;
    public final int offset;

    private ShortPtr() {
        this.array = null;
        this.offset = 0;
    }

    public ShortPtr(short[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public ShortPtr(short ... array) {
        this.array = array;
        this.offset = 0;
    }

    public short[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        return new ShortPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 2));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new ShortPtr(this.array, this.offset + bytes / 2);
    }

    public short unwrap() {
        return this.array[this.offset];
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static void memset(short[] array, int offset, int value, int length) {
        throw new UnsupportedOperationException("TODO");
    }

    public static short memset(int byteValue) {
        throw new UnsupportedOperationException("TODO");
    }

    public static ShortPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).shortPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (ShortPtr)voidPointer;
    }
}

