/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.SSLUtil;
import com.paypal.exception.SSLConfigurationException;
import com.sun.net.ssl.HttpsURLConnection;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.SSLContext;

public class DefaultHttpConnection
extends HttpConnection {
    private SSLContext sslContext;

    public DefaultHttpConnection() {
        try {
            this.sslContext = SSLUtil.getSSLContext(null);
        }
        catch (SSLConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setupClientSSL(String certPath, String certKey) throws SSLConfigurationException {
        try {
            this.sslContext = SSLUtil.setupClientSSL(certPath, certKey);
        }
        catch (Exception e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
    }

    public void createAndconfigureHttpConnection(HttpConfiguration clientConfiguration) throws IOException {
        this.config = clientConfiguration;
        URL url = new URL(this.config.getEndPointUrl());
        Proxy proxy = null;
        String proxyHost = this.config.getProxyHost();
        int proxyPort = this.config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        this.connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        if (this.connection instanceof javax.net.ssl.HttpsURLConnection) {
            ((javax.net.ssl.HttpsURLConnection)this.connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
        } else if (this.connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)this.connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        if (this.config.getProxyUserName() != null && this.config.getProxyPassword() != null) {
            String username = this.config.getProxyUserName();
            String password = this.config.getProxyPassword();
            DefaultPasswordAuthenticator authenticator = new DefaultPasswordAuthenticator(username, password);
            Authenticator.setDefault(authenticator);
        }
        System.setProperty("http.maxConnections", String.valueOf(this.config.getMaxHttpConnection()));
        System.setProperty("sun.net.http.errorstream.enableBuffering", "true");
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        DefaultHttpConnection.setRequestMethodViaJreBugWorkaround(this.connection, this.config.getHttpMethod());
        this.connection.setConnectTimeout(this.config.getConnectionTimeout());
        this.connection.setReadTimeout(this.config.getReadTimeout());
    }

    private static void setRequestMethodViaJreBugWorkaround(final HttpURLConnection httpURLConnection, final String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            try {
                Class<?> httpURLConnectionClass = httpURLConnection.getClass();
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws NoSuchFieldException, IllegalAccessException {
                        try {
                            httpURLConnection.setRequestMethod(method);
                        }
                        catch (ProtocolException pe) {
                            Class<?> connectionClass = httpURLConnection.getClass();
                            try {
                                Field delegateField = connectionClass.getDeclaredField("delegate");
                                delegateField.setAccessible(true);
                                HttpURLConnection delegateConnection = (HttpURLConnection)delegateField.get(httpURLConnection);
                                DefaultHttpConnection.setRequestMethodViaJreBugWorkaround(delegateConnection, method);
                            }
                            catch (NoSuchFieldException delegateConnection) {
                            }
                            catch (IllegalArgumentException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            try {
                                while (connectionClass != null) {
                                    Field methodField;
                                    try {
                                        methodField = connectionClass.getDeclaredField("method");
                                    }
                                    catch (NoSuchFieldException e) {
                                        connectionClass = connectionClass.getSuperclass();
                                        continue;
                                    }
                                    methodField.setAccessible(true);
                                    methodField.set(httpURLConnection, method);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    private static class DefaultPasswordAuthenticator
    extends Authenticator {
        private String userName;
        private String password;

        public DefaultPasswordAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

