/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.LoggingManager;
import com.paypal.exception.SSLConfigurationException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class GoogleAppEngineHttpConnection
extends HttpConnection {
    public void setupClientSSL(String certPath, String certKey) throws SSLConfigurationException {
        if (certPath != null || certKey != null) {
            LoggingManager.warn(GoogleAppEngineHttpConnection.class, "The PayPal SDK cannot be used with client SSL on Google App Engine; configure the SDK to use a PayPal API Signature instead");
        }
    }

    public void createAndconfigureHttpConnection(HttpConfiguration clientConfiguration) throws IOException {
        this.config = clientConfiguration;
        URL url = new URL(this.config.getEndPointUrl());
        this.connection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(this.config.getHttpMethod());
        this.connection.setConnectTimeout(this.config.getConnectionTimeout());
        this.connection.setReadTimeout(this.config.getReadTimeout());
    }
}

