/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util;

import java.io.UnsupportedEncodingException;

public final class PayPalURLEncoder {
    static final String DIGITS = "0123456789abcdef";

    private PayPalURLEncoder() {
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        if (s == null || enc == null) {
            throw new NullPointerException();
        }
        StringBuffer buf = new StringBuffer(s.length() + 16);
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " _".indexOf(ch) > -1) {
                if (start >= 0) {
                    PayPalURLEncoder.convert(s.substring(start, i), buf, enc);
                    start = -1;
                }
                if (ch != ' ') {
                    buf.append(ch);
                    continue;
                }
                buf.append('+');
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            PayPalURLEncoder.convert(s.substring(start, s.length()), buf, enc);
        }
        return buf.toString();
    }

    private static void convert(String s, StringBuffer buf, String enc) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(enc);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append(DIGITS.charAt((bytes[j] & 0xF0) >> 4));
            buf.append(DIGITS.charAt(bytes[j] & 0xF));
        }
    }
}

