/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.common.KeyHelper;
import org.structr.net.peer.Peer;
import org.structr.net.protocol.BroadcastMessage;
import org.structr.net.protocol.DirectMessage;
import org.structr.net.repository.DefaultRepository;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger((String)Main.class.getName());

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = UUID.randomUUID().toString().replaceAll("\\-", "");
        String string2 = "255.255.255.255";
        String string3 = "0.0.0.0";
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block52: for (int i = 0; i < stringArray.length; ++i) {
            switch (stringArray[i]) {
                case "-i": {
                    System.out.println("Interactive mode enabled.");
                    bl2 = true;
                    continue block52;
                }
                case "-b": {
                    string3 = stringArray[i + 1];
                    System.out.println("Bind address set to " + string3);
                    continue block52;
                }
                case "-p": {
                    string2 = stringArray[i + 1];
                    System.out.println("Initial peer set to " + string2);
                    continue block52;
                }
                case "-v": {
                    bl3 = true;
                    System.out.println("Verbose mode enabled.");
                    continue block52;
                }
                case "-u": {
                    string = stringArray[i + 1];
                    System.out.println("Client UUID set to " + string);
                    continue block52;
                }
                case "--print-keys": {
                    bl = true;
                    System.out.println("Printing peer keys.");
                    continue block52;
                }
                case "--private-key-file": {
                    string4 = stringArray[i + 1];
                    System.out.println("Using private key from " + string4);
                    continue block52;
                }
                case "--public-key-file": {
                    string5 = stringArray[i + 1];
                    System.out.println("Using public key from " + string5);
                    continue block52;
                }
                case "-h": {
                    Main.printHelp();
                    System.exit(0);
                }
            }
        }
        DefaultRepository defaultRepository = new DefaultRepository(string);
        Object object3 = null;
        if (string4 != null && string5 != null) {
            try {
                Base64.Decoder decoder = Base64.getDecoder();
                object2 = decoder.decode(Main.readBase64(string4));
                object = decoder.decode(Main.readBase64(string5));
                object3 = KeyHelper.fromBytes("RSA", (byte[])object2, (byte[])object);
            }
            catch (IOException iOException) {
                logger.warn("", (Throwable)iOException);
            }
        } else {
            object3 = KeyHelper.getOrCreateKeyPair("RSA", 2048);
        }
        Peer peer = new Peer((KeyPair)object3, defaultRepository, string3, string2);
        if (bl && object3 != null) {
            object2 = Base64.getEncoder();
            System.out.println("Private key (BASE64 encoded): " + ((Base64.Encoder)object2).encodeToString(((KeyPair)object3).getPrivate().getEncoded()));
            System.out.println("Public key (BASE64 encoded):  " + ((Base64.Encoder)object2).encodeToString(((KeyPair)object3).getPublic().getEncoded()));
        }
        defaultRepository.setPeer(peer);
        peer.setVerbose(bl3);
        peer.initializeServer();
        peer.start();
        if (bl2) {
            object2 = new BufferedReader(new InputStreamReader(System.in));
            object = null;
            do {
                try {
                    String string6;
                    System.out.print(peer.getLocalPort() + "> ");
                    object = ((BufferedReader)object2).readLine();
                    String[] stringArray2 = ((String)object).split("[ ]+");
                    switch (string6 = stringArray2[0]) {
                        case "exit": {
                            peer.stop();
                            break;
                        }
                        case "i": {
                            peer.printInfo();
                            break;
                        }
                        case "kill": {
                            peer.broadcast(new BroadcastMessage(peer.getUuid(), "kill"));
                            break;
                        }
                        case "info": {
                            peer.broadcast(new BroadcastMessage(peer.getUuid(), "info"));
                            break;
                        }
                        case "span": {
                            peer.broadcast(new BroadcastMessage(peer.getUuid(), "span"));
                            break;
                        }
                        case "msg": {
                            if (stringArray2.length < 3) {
                                System.out.println("usage: msg <peer> <message>");
                                break;
                            }
                            peer.broadcast(new DirectMessage(peer.getUuid(), stringArray2[1], stringArray2[2]));
                            break;
                        }
                        case "broadcast": {
                            if (stringArray2.length < 2) {
                                System.out.println("usage: broadcast <message>");
                                break;
                            }
                            peer.broadcast(new BroadcastMessage(peer.getUuid(), stringArray2[1]));
                            break;
                        }
                        case "ping": {
                            if (stringArray2.length < 2) {
                                System.out.println("usage: ping <peer>");
                                break;
                            }
                            peer.broadcast(new DirectMessage(peer.getUuid(), stringArray2[1], "ping"));
                            break;
                        }
                        case "new": {
                            if (stringArray2.length < 3) {
                                System.out.println("usage: new <type> <owner> [<key> <value>]...");
                                break;
                            }
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            String string7 = null;
                            for (int i = 3; i < stringArray2.length; ++i) {
                                if (string7 == null) {
                                    string7 = stringArray2[i];
                                    continue;
                                }
                                System.out.println(string7 + " = " + stringArray2[i]);
                                hashMap.put(string7, stringArray2[i]);
                                string7 = null;
                            }
                            defaultRepository.create(UUID.randomUUID().toString().replaceAll("\\-", ""), stringArray2[1], peer.getUuid(), stringArray2[2], peer.getPseudoTemporalEnvironment().next(), hashMap);
                            break;
                        }
                        case "get": {
                            if (stringArray2.length < 3) {
                                System.out.println("usage: get <id> <key>");
                                break;
                            }
                            peer.get(stringArray2[1], stringArray2[2]);
                            break;
                        }
                        case "set": {
                            if (stringArray2.length < 4) {
                                System.out.println("usage: set <id> <key> <value>");
                                break;
                            }
                            peer.set(stringArray2[1], stringArray2[2], stringArray2[3]);
                        }
                    }
                }
                catch (Throwable throwable) {
                    logger.warn("", throwable);
                }
            } while (peer.isRunning() && !((String)object).equals("quit"));
            peer.stop();
        }
    }

    private static void printHelp() {
        System.out.println("structr-net Client command line options");
        System.out.println(" -b <addr>      - set bind address");
        System.out.println(" -h             - show this help message ");
        System.out.println(" -i             - enable interactive mode");
        System.out.println(" -p <addr>      - set initial peer");
        System.out.println(" -u <uuid>      - set peer UUID ");
        System.out.println(" -v             - enable verbose mode");
    }

    private static String readBase64(String string) throws IOException {
        return Main.getKey(Files.readAllLines(Paths.get(string, new String[0])));
    }

    private static String getKey(List<String> list) {
        for (String string : list) {
            if (string.contains("#")) {
                String string2 = string.substring(0, string.indexOf("#"));
                if (string2.isEmpty()) continue;
                return string2;
            }
            if (string.isEmpty()) continue;
            return string;
        }
        return null;
    }
}

