/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.common;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)KeyHelper.class.getName());

    public static KeyPair getOrCreateKeyPair(String string, int n) {
        return KeyHelper.fromFile(string, n, "/tmp/privatekey.bin", "/tmp/publickey.bin");
    }

    public static KeyPair fromFile(String string, int n, String string2, String string3) {
        File file = new File(string2);
        File file2 = new File(string3);
        if (file.exists() && file2.exists()) {
            PrivateKey privateKey = KeyHelper.getPrivateKey(string, file);
            PublicKey publicKey = KeyHelper.getPublicKey(string, file2);
            return new KeyPair(publicKey, privateKey);
        }
        return KeyHelper.createKeyPair(string, n, string2, string3);
    }

    public static KeyPair fromBytes(String string, byte[] byArray, byte[] byArray2) {
        PrivateKey privateKey = KeyHelper.getPrivateKeyFromBytes(string, byArray);
        PublicKey publicKey = KeyHelper.getPublicKeyFromBytes(string, byArray2);
        return new KeyPair(publicKey, privateKey);
    }

    private static PrivateKey getPrivateKey(String string, File file) {
        return KeyHelper.getPrivateKeyFromBytes(string, KeyHelper.readBytes(file));
    }

    private static PublicKey getPublicKey(String string, File file) {
        return KeyHelper.getPublicKeyFromBytes(string, KeyHelper.readBytes(file));
    }

    private static PrivateKey getPrivateKeyFromBytes(String string, byte[] byArray) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }

    private static PublicKey getPublicKeyFromBytes(String string, byte[] byArray) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }

    private static KeyPair createKeyPair(String string, int n, String string2, String string3) {
        try {
            File file = new File(string3);
            File file2 = new File(string2);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            if (!file.exists() || !file2.exists()) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(publicKey.getEncoded());
                    fileOutputStream.flush();
                }
                fileOutputStream = new FileOutputStream(file2);
                var11_12 = null;
                try {
                    fileOutputStream.write(privateKey.getEncoded());
                    fileOutputStream.flush();
                }
                catch (Throwable throwable) {
                    var11_12 = throwable;
                    throw throwable;
                }
                finally {
                    if (fileOutputStream != null) {
                        if (var11_12 != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                var11_12.addSuppressed(throwable);
                            }
                        } else {
                            fileOutputStream.close();
                        }
                    }
                }
            }
            return keyPair;
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }

    private static byte[] readBytes(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (Throwable throwable) {
            logger.warn("", throwable);
            return null;
        }
    }
}

