/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.data.time;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.structr.net.data.time.Clock;
import org.structr.net.protocol.AbstractMessage;
import org.structr.net.protocol.ProtocolEntity;

public class PseudoTime
implements Comparable<PseudoTime>,
ProtocolEntity {
    private long instant = 0L;
    private String uuid = null;
    private long timeDerived = 0L;
    private long tick = 0L;

    public PseudoTime() {
    }

    public PseudoTime(long l, String string, long l2) {
        this(l, string, l2, 0L);
    }

    public PseudoTime(long l, String string, long l2, long l3) {
        this.uuid = string;
        this.instant = l;
        this.timeDerived = l2;
        this.tick = l3;
    }

    public String toString() {
        return this.instant + "." + this.uuid + "." + this.pad(this.timeDerived) + "." + this.pad(this.tick);
    }

    public long getTimestamp() {
        return this.instant;
    }

    public boolean after(PseudoTime pseudoTime) {
        return this.compareTo(pseudoTime) == 1;
    }

    public boolean before(PseudoTime pseudoTime) {
        return this.compareTo(pseudoTime) == -1;
    }

    public PseudoTime next() {
        return new PseudoTime(this.instant, this.uuid, this.timeDerived, this.tick + 1L);
    }

    @Override
    public int compareTo(PseudoTime pseudoTime) {
        if (this.instant == pseudoTime.instant) {
            if (this.uuid.equals(pseudoTime.uuid)) {
                if (this.timeDerived == pseudoTime.timeDerived) {
                    if (this.tick == pseudoTime.tick) {
                        return 0;
                    }
                    return this.compare(this.tick, pseudoTime.tick);
                }
                return this.compare(this.timeDerived, pseudoTime.timeDerived);
            }
            return this.uuid.compareTo(pseudoTime.uuid);
        }
        return this.compare(this.instant, pseudoTime.instant);
    }

    private int compare(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    private String pad(long l) {
        if (l < 100L) {
            if (l < 10L) {
                return "00" + l;
            }
            return "0" + l;
        }
        return String.valueOf(l);
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(this.instant);
        AbstractMessage.serializeUUID(dataOutputStream, this.uuid);
        dataOutputStream.writeLong(this.timeDerived);
        dataOutputStream.writeLong(this.tick);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        this.instant = dataInputStream.readLong();
        this.uuid = AbstractMessage.deserializeUUID(dataInputStream);
        this.timeDerived = dataInputStream.readLong();
        this.tick = dataInputStream.readLong();
    }

    public static PseudoTime fromStream(DataInputStream dataInputStream) throws IOException {
        PseudoTime pseudoTime = new PseudoTime();
        pseudoTime.deserialize(dataInputStream);
        return pseudoTime;
    }

    public static PseudoTime fromString(String string) {
        PseudoTime pseudoTime = new PseudoTime();
        if (string != null) {
            String[] stringArray = string.split("[\\.]+");
            switch (stringArray.length) {
                case 4: {
                    pseudoTime.tick = Long.valueOf(stringArray[3]);
                }
                case 3: {
                    pseudoTime.timeDerived = Long.valueOf(stringArray[2]);
                }
                case 2: {
                    pseudoTime.uuid = stringArray[1];
                }
                case 1: {
                    pseudoTime.instant = Long.valueOf(stringArray[0]);
                }
            }
        } else {
            pseudoTime.instant = System.currentTimeMillis();
            pseudoTime.uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        }
        return pseudoTime;
    }

    public static PseudoTime now(Clock clock) {
        PseudoTime pseudoTime = new PseudoTime();
        pseudoTime.instant = clock.getTime();
        pseudoTime.uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        return pseudoTime;
    }

    public static PseudoTime fromTimestamp(long l, String string) {
        PseudoTime pseudoTime = new PseudoTime();
        pseudoTime.instant = l;
        pseudoTime.uuid = string;
        return pseudoTime;
    }

    public static PseudoTime epoch() {
        PseudoTime pseudoTime = new PseudoTime();
        pseudoTime.instant = 0L;
        pseudoTime.uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        return pseudoTime;
    }
}

