/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.data.time;

import java.util.UUID;
import org.structr.net.data.time.Clock;
import org.structr.net.data.time.DerivedTemporalEnvironment;
import org.structr.net.data.time.PseudoTemporalEnvironment;
import org.structr.net.data.time.PseudoTime;

public class ToplevelTemporalEnvironment
implements PseudoTemporalEnvironment {
    private Clock clock = null;
    private String uuid = null;
    private long lastTime = System.currentTimeMillis();

    public ToplevelTemporalEnvironment(Clock clock) {
        this.uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
        this.clock = clock;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    @Override
    public PseudoTemporalEnvironment transaction() {
        this.next();
        return new DerivedTemporalEnvironment(this.lastTime, this.uuid, 0L);
    }

    @Override
    public PseudoTime current() {
        return new PseudoTime(this.lastTime, this.uuid, 0L);
    }

    @Override
    public PseudoTime next() {
        long l = this.clock.getTime();
        while (l < this.lastTime) {
            this.sleep(10L);
            l = this.clock.getTime();
        }
        this.lastTime = l;
        return this.current();
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

