/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Ack;
import org.structr.net.protocol.BeginTx;
import org.structr.net.protocol.BroadcastMessage;
import org.structr.net.protocol.Commit;
import org.structr.net.protocol.Committed;
import org.structr.net.protocol.Delete;
import org.structr.net.protocol.DirectMessage;
import org.structr.net.protocol.Discovery;
import org.structr.net.protocol.Envelope;
import org.structr.net.protocol.Get;
import org.structr.net.protocol.GetHistory;
import org.structr.net.protocol.History;
import org.structr.net.protocol.Inventory;
import org.structr.net.protocol.Set;
import org.structr.net.protocol.Update;
import org.structr.net.protocol.Value;

public abstract class AbstractMessage {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractMessage.class.getName());
    private static final Map<Integer, Class<? extends AbstractMessage>> CommandMap = new HashMap<Integer, Class<? extends AbstractMessage>>();
    private static final Map<Class, Integer> TypeMap = new HashMap<Class, Integer>();
    private String uuid = UUID.randomUUID().toString().replaceAll("\\-", "");
    private int command = 0;
    private long timestamp = 0L;

    public abstract void onMessage(Peer var1, PeerInfo var2);

    public abstract void serialize(DataOutputStream var1) throws IOException;

    public abstract void deserialize(DataInputStream var1) throws IOException;

    protected AbstractMessage(int n) {
        this.command = n;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void onSend(Peer peer) {
    }

    public void reBroadcast(Peer peer, PeerInfo peerInfo) {
    }

    public String getId() {
        return this.uuid;
    }

    public void setId(String string) {
        this.uuid = string;
    }

    public int getCommand() {
        return this.command;
    }

    public long getSenderTimestamp() {
        return this.timestamp;
    }

    public void setSenderTimestamp(long l) {
        this.timestamp = l;
    }

    public static Envelope receive(Peer peer, DatagramPacket datagramPacket) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        PrivateKey privateKey = peer.getPrivateKey();
        if (privateKey != null) {
            Cipher cipher = AbstractMessage.getCipher();
            cipher.init(2, peer.getPrivateKey());
            byte[] byArray = AbstractMessage.decryptBlocks(datagramPacket.getData(), cipher, 256, 245);
            if (byArray.length == 0) {
                System.out.println("Decryption failed");
            } else {
                DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream((InputStream)new ByteArrayInputStream(byArray), 1024));
                int n = dataInputStream.readInt();
                String string = AbstractMessage.deserializeUUID(dataInputStream);
                String string2 = AbstractMessage.deserializeUUID(dataInputStream);
                long l = dataInputStream.readLong();
                AbstractMessage abstractMessage = null;
                Class<? extends AbstractMessage> clazz = CommandMap.get(n);
                if (clazz != null) {
                    try {
                        abstractMessage = clazz.newInstance();
                        abstractMessage.setSenderTimestamp(l);
                        abstractMessage.setId(string);
                        abstractMessage.deserialize(dataInputStream);
                        return new Envelope(new PeerInfo(peer.getPublicKey(), string2, datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort()), abstractMessage);
                    }
                    catch (Throwable throwable) {
                        logger.warn("", throwable);
                    }
                } else {
                    System.out.println("Unknown command " + n);
                }
            }
        } else {
            System.out.println("Unable to decrypt packet, aborting");
        }
        return null;
    }

    public static DatagramPacket forSending(String string, PeerInfo peerInfo, AbstractMessage abstractMessage) throws UnknownHostException, IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)byteArrayOutputStream, 1024);
        DataOutputStream dataOutputStream = new DataOutputStream(gZIPOutputStream);
        dataOutputStream.writeInt(abstractMessage.getCommand());
        AbstractMessage.serializeUUID(dataOutputStream, abstractMessage.getId());
        AbstractMessage.serializeUUID(dataOutputStream, string);
        dataOutputStream.writeLong(abstractMessage.getSenderTimestamp());
        abstractMessage.serialize(dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        PublicKey publicKey = peerInfo.getPublicKey();
        if (publicKey != null) {
            Cipher cipher = AbstractMessage.getCipher();
            cipher.init(1, publicKey);
            byte[] byArray = AbstractMessage.encryptBlocks(byteArrayOutputStream.toByteArray(), cipher, 245);
            String string2 = peerInfo.getAddress();
            int n = peerInfo.getPort();
            return new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string2), n);
        }
        System.out.println("Unable to encrypt packet, aborting.");
        return null;
    }

    protected void serializeObject(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object != null) {
            Integer n = TypeMap.get(object.getClass());
            if (n != null) {
                dataOutputStream.writeInt(n);
                switch (n) {
                    case 1: {
                        dataOutputStream.writeUTF((String)object);
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeInt((Integer)object);
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeLong((Long)object);
                        break;
                    }
                    case 4: {
                        dataOutputStream.writeBoolean((Boolean)object);
                        break;
                    }
                    case 5: {
                        dataOutputStream.writeDouble((Double)object);
                        break;
                    }
                    case 6: {
                        dataOutputStream.writeFloat(((Float)object).floatValue());
                        break;
                    }
                    case 100: {
                        this.serializeList(dataOutputStream, (List)object);
                    }
                }
            } else {
                System.out.println("Unknown type " + object.getClass() + ", cannot serialize!");
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    public static void serializeUUID(DataOutputStream dataOutputStream, String string) throws IOException {
        UUID uUID = AbstractMessage.toUUID(string);
        dataOutputStream.writeLong(uUID.getLeastSignificantBits());
        dataOutputStream.writeLong(uUID.getMostSignificantBits());
    }

    public static String deserializeUUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = dataInputStream.readLong();
        UUID uUID = new UUID(l2, l);
        return uUID.toString().replaceAll("\\-", "");
    }

    protected Object deserializeObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        switch (n) {
            default: {
                return null;
            }
            case 1: {
                return dataInputStream.readUTF();
            }
            case 2: {
                return dataInputStream.readInt();
            }
            case 3: {
                return dataInputStream.readLong();
            }
            case 4: {
                return dataInputStream.readBoolean();
            }
            case 5: {
                return dataInputStream.readDouble();
            }
            case 6: {
                return Float.valueOf(dataInputStream.readFloat());
            }
            case 100: 
        }
        return this.deserializeList(dataInputStream);
    }

    private void serializeList(DataOutputStream dataOutputStream, List<Object> list) throws IOException {
        dataOutputStream.writeInt(list.size());
        for (Object object : list) {
            this.serializeObject(dataOutputStream, object);
        }
    }

    private List deserializeList(DataInputStream dataInputStream) throws IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.deserializeObject(dataInputStream));
        }
        return linkedList;
    }

    private static Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("RSA/ECB/PKCS1Padding");
    }

    private static UUID toUUID(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.insert(20, "-");
        stringBuilder.insert(16, "-");
        stringBuilder.insert(12, "-");
        stringBuilder.insert(8, "-");
        return UUID.fromString(stringBuilder.toString());
    }

    private static byte[] encryptBlocks(byte[] byArray, Cipher cipher, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n2 = byArray.length / n + 1;
        int n3 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n;
            int n5 = Math.min(n, n3);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
            cipherOutputStream.write(byArray, n4, n5);
            cipherOutputStream.flush();
            cipherOutputStream.close();
            n3 -= n5;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decryptBlocks(byte[] byArray, Cipher cipher, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n3 = byArray.length / n2;
        byte[] byArray2 = new byte[n2];
        int n4 = byArray.length;
        for (int i = 0; i < n3; ++i) {
            int n5 = i * n;
            int n6 = Math.min(n, n4);
            byte[] byArray3 = Arrays.copyOfRange(byArray, n5, n5 + n6);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
            try {
                Arrays.fill(byArray2, 0, n2, (byte)0);
                cipherInputStream.read(byArray2, 0, n2);
                byteArrayOutputStream.write(byArray2);
                n4 -= Math.min(n, n4);
                continue;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        CommandMap.put(0, Discovery.class);
        CommandMap.put(2, BroadcastMessage.class);
        CommandMap.put(3, DirectMessage.class);
        CommandMap.put(4, Update.class);
        CommandMap.put(5, Delete.class);
        CommandMap.put(6, Update.class);
        CommandMap.put(7, Get.class);
        CommandMap.put(8, Value.class);
        CommandMap.put(9, Set.class);
        CommandMap.put(10, BeginTx.class);
        CommandMap.put(12, Commit.class);
        CommandMap.put(13, Committed.class);
        CommandMap.put(14, Ack.class);
        CommandMap.put(15, GetHistory.class);
        CommandMap.put(16, History.class);
        CommandMap.put(17, Inventory.class);
        TypeMap.put(String.class, 1);
        TypeMap.put(Integer.class, 2);
        TypeMap.put(Long.class, 3);
        TypeMap.put(Boolean.class, 4);
        TypeMap.put(Double.class, 5);
        TypeMap.put(Float.class, 6);
        TypeMap.put(LinkedList.class, 100);
    }
}

