/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Ack;
import org.structr.net.protocol.Message;

public class BeginTx
extends Message {
    private String recipient = null;
    private long timeout = 0L;

    public BeginTx() {
        this(null, null, 0L);
    }

    public BeginTx(String string, String string2, long l) {
        super(10, string);
        this.recipient = string2;
        this.timeout = l;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            String string = peer.getRepository().beginTransaction(this.timeout);
            peer.broadcast(new Ack(peer.getUuid(), this.getSender(), this.getId(), string));
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        BeginTx.serializeUUID(dataOutputStream, this.recipient);
        dataOutputStream.writeLong(this.timeout);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = BeginTx.deserializeUUID(dataInputStream);
        this.timeout = dataInputStream.readLong();
    }
}

