/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Ack;
import org.structr.net.protocol.Committed;
import org.structr.net.protocol.Message;

public class Commit
extends Message {
    private String recipient = null;
    private String transactionId = null;

    public Commit() {
        this(null, null, null);
    }

    public Commit(String string, String string2, String string3) {
        super(12, string);
        this.recipient = string2;
        this.transactionId = string3;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            peer.getRepository().complete(this.transactionId);
            peer.broadcast(new Ack(peer.getUuid(), this.getSender(), this.getId()));
            peer.broadcast(new Committed(peer.getUuid(), this.getSender(), this.transactionId));
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Commit.serializeUUID(dataOutputStream, this.recipient);
        Commit.serializeUUID(dataOutputStream, this.transactionId);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = Commit.deserializeUUID(dataInputStream);
        this.transactionId = Commit.deserializeUUID(dataInputStream);
    }
}

