/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.AbstractMessage;

public class Discovery
extends AbstractMessage {
    private boolean isReply = false;
    private byte[] hash = null;

    public Discovery() {
        this(null, false);
    }

    public Discovery(byte[] byArray) {
        this(byArray, false);
    }

    public Discovery(byte[] byArray, boolean bl) {
        super(0);
        this.hash = byArray;
        this.isReply = bl;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        peer.onPeerDiscovery(peerInfo, this.hash);
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.hash.length);
        dataOutputStream.write(this.hash, 0, this.hash.length);
        dataOutputStream.writeBoolean(this.isReply);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.hash = new byte[n];
        dataInputStream.read(this.hash, 0, n);
        this.isReply = dataInputStream.readBoolean();
    }
}

