/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.GetHistory;
import org.structr.net.protocol.Message;
import org.structr.net.protocol.Value;
import org.structr.net.repository.RepositoryObject;

public class Get
extends Message {
    private String recipient = null;
    private String transactionId = null;
    private PseudoTime time = null;
    private String objectId = null;
    private String key = null;

    public Get() {
        this(null, null, null, null, null);
    }

    public Get(String string, RepositoryObject repositoryObject, PseudoTime pseudoTime, String string2, String string3) {
        super(7, string);
        this.recipient = repositoryObject != null ? repositoryObject.getDeviceId() : null;
        this.objectId = repositoryObject != null ? repositoryObject.getUuid() : null;
        this.transactionId = string2;
        this.time = pseudoTime;
        this.key = string3;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            RepositoryObject repositoryObject = peer.getRepository().getObject(this.objectId);
            Object object = repositoryObject.getProperty(this.time, this.transactionId, this.key);
            peer.broadcast(new Value(peer.getUuid(), this.getSender(), this.getId(), object));
        } else {
            RepositoryObject repositoryObject = peer.getRepository().getObject(this.objectId);
            if (repositoryObject == null) {
                peer.log("Unknown object ", this.objectId, ", requesting full history..");
                peer.broadcast(new GetHistory(peer.getUuid(), this.recipient, this.objectId, PseudoTime.now(peer)));
            }
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Get.serializeUUID(dataOutputStream, this.recipient);
        Get.serializeUUID(dataOutputStream, this.objectId);
        Get.serializeUUID(dataOutputStream, this.transactionId);
        dataOutputStream.writeUTF(this.key);
        this.time.serialize(dataOutputStream);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = Get.deserializeUUID(dataInputStream);
        this.objectId = Get.deserializeUUID(dataInputStream);
        this.transactionId = Get.deserializeUUID(dataInputStream);
        this.key = dataInputStream.readUTF();
        this.time = new PseudoTime();
        this.time.deserialize(dataInputStream);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public PseudoTime getTime() {
        return this.time;
    }
}

