/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.History;
import org.structr.net.protocol.Message;
import org.structr.net.repository.RepositoryObject;

public class GetHistory
extends Message {
    private PseudoTime instant = null;
    private String recipient = null;
    private String objectId = null;

    public GetHistory() {
        this(null, null, null, null);
    }

    public GetHistory(String string, String string2, String string3, PseudoTime pseudoTime) {
        super(15, string);
        this.instant = pseudoTime;
        this.recipient = string2;
        this.objectId = string3;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            RepositoryObject repositoryObject = peer.getRepository().getObject(this.objectId);
            if (repositoryObject != null) {
                PseudoTime pseudoTime = repositoryObject.getLastModificationTime();
                if (pseudoTime.before(this.instant)) {
                    Map<String, Object> map = repositoryObject.getProperties(this.instant);
                    peer.log("History(", this.objectId, ")");
                    peer.broadcast(new History(peer.getUuid(), this.getSender(), this.objectId, repositoryObject.getType(), repositoryObject.getUserId(), repositoryObject.getCreationTime(), pseudoTime, map));
                } else {
                    peer.log("GetHistory(", this.objectId, "): not modified");
                }
            } else {
                peer.log("GetHistory(", this.objectId, "): object not found");
            }
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        GetHistory.serializeUUID(dataOutputStream, this.recipient);
        GetHistory.serializeUUID(dataOutputStream, this.objectId);
        this.instant.serialize(dataOutputStream);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = GetHistory.deserializeUUID(dataInputStream);
        this.objectId = GetHistory.deserializeUUID(dataInputStream);
        this.instant = new PseudoTime();
        this.instant.deserialize(dataInputStream);
    }
}

