/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Message;
import org.structr.net.repository.Repository;
import org.structr.net.repository.RepositoryObject;

public class History
extends Message {
    private static final Logger logger = LoggerFactory.getLogger((String)History.class.getName());
    private final Map<String, Object> data = new HashMap<String, Object>();
    private PseudoTime creationTime = null;
    private PseudoTime lastModified = null;
    private String recipient = null;
    private String objectId = null;
    private String userId = null;
    private String type = null;

    public History() {
        this(null, null, null, null, null, null, null, null);
    }

    public History(String string, String string2, String string3, String string4, String string5, PseudoTime pseudoTime, PseudoTime pseudoTime2, Map<String, Object> map) {
        super(16, string);
        this.lastModified = pseudoTime2;
        this.creationTime = pseudoTime;
        this.recipient = string2;
        this.objectId = string3;
        this.userId = string5;
        this.type = string4;
        if (map != null) {
            this.data.putAll(map);
        }
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        if (peer.getUuid().equals(this.recipient)) {
            Repository repository = peer.getRepository();
            if (!repository.contains(this.objectId)) {
                repository.objectCreated(this.objectId, this.type, this.getSender(), this.userId, this.creationTime, this.lastModified, this.data);
            } else {
                RepositoryObject repositoryObject = repository.getObject(this.objectId);
                if (repositoryObject != null) {
                    String string = UUID.randomUUID().toString().replaceAll("\\-", "");
                    for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                        repositoryObject.setProperty(this.lastModified, string, entry.getKey(), entry.getValue());
                    }
                    repository.complete(string);
                }
            }
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        History.serializeUUID(dataOutputStream, this.recipient);
        History.serializeUUID(dataOutputStream, this.objectId);
        dataOutputStream.writeUTF(this.userId);
        dataOutputStream.writeUTF(this.type);
        this.creationTime.serialize(dataOutputStream);
        this.lastModified.serialize(dataOutputStream);
        int n = this.data.size();
        dataOutputStream.writeInt(n);
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            this.serializeObject(dataOutputStream, entry.getValue());
        }
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = History.deserializeUUID(dataInputStream);
        this.objectId = History.deserializeUUID(dataInputStream);
        this.userId = dataInputStream.readUTF();
        this.type = dataInputStream.readUTF();
        this.creationTime = new PseudoTime();
        this.creationTime.deserialize(dataInputStream);
        this.lastModified = new PseudoTime();
        this.lastModified.deserialize(dataInputStream);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                String string = dataInputStream.readUTF();
                Object object = this.deserializeObject(dataInputStream);
                this.data.put(string, object);
                continue;
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }
}

