/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.GetHistory;
import org.structr.net.protocol.Message;
import org.structr.net.repository.RepositoryObject;

public class Inventory
extends Message {
    private PseudoTime lastModificationDate = null;
    private String objectId = null;
    private String owner = null;

    public Inventory() {
        this(null, null, null, null);
    }

    public Inventory(String string, String string2, String string3, PseudoTime pseudoTime) {
        super(17, string);
        this.lastModificationDate = pseudoTime;
        this.objectId = string2;
        this.owner = string3;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        RepositoryObject repositoryObject;
        if (!peer.getUuid().equals(this.getSender()) && ((repositoryObject = peer.getRepository().getObject(this.objectId)) == null || repositoryObject.getLastModificationTime().before(this.lastModificationDate))) {
            peer.log("GetHistory(", this.objectId, ")");
            peer.broadcast(new GetHistory(peer.getUuid(), this.getSender(), this.objectId, PseudoTime.now(peer)));
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Inventory.serializeUUID(dataOutputStream, this.objectId);
        Inventory.serializeUUID(dataOutputStream, this.owner);
        this.lastModificationDate.serialize(dataOutputStream);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.objectId = Inventory.deserializeUUID(dataInputStream);
        this.owner = Inventory.deserializeUUID(dataInputStream);
        this.lastModificationDate = new PseudoTime();
        this.lastModificationDate.deserialize(dataInputStream);
    }
}

