/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Ack;
import org.structr.net.protocol.GetHistory;
import org.structr.net.protocol.Message;
import org.structr.net.repository.RepositoryObject;

public class Set
extends Message {
    private String recipient = null;
    private PseudoTime time = null;
    private String objectId = null;
    private String transactionId = null;
    private String key = null;
    private Object value = null;

    public Set() {
        this(null, null, null, null, null, null);
    }

    public Set(String string, RepositoryObject repositoryObject, PseudoTime pseudoTime, String string2, String string3, Object object) {
        super(9, string);
        this.recipient = repositoryObject != null ? repositoryObject.getDeviceId() : null;
        this.objectId = repositoryObject != null ? repositoryObject.getUuid() : null;
        this.transactionId = string2;
        this.key = string3;
        this.value = object;
        this.time = pseudoTime;
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        RepositoryObject repositoryObject = peer.getRepository().getObject(this.objectId);
        if (repositoryObject != null) {
            repositoryObject.setProperty(this.time, this.transactionId, this.key, this.value);
            if (peer.getUuid().equals(this.recipient)) {
                peer.broadcast(new Ack(peer.getUuid(), this.getSender(), this.getId()));
            }
        } else {
            peer.log("Unknown object ", this.objectId, ", requesting full history..");
            peer.broadcast(new GetHistory(peer.getUuid(), this.recipient, this.objectId, PseudoTime.now(peer)));
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Set.serializeUUID(dataOutputStream, this.recipient);
        Set.serializeUUID(dataOutputStream, this.objectId);
        Set.serializeUUID(dataOutputStream, this.transactionId);
        dataOutputStream.writeUTF(this.key);
        this.serializeObject(dataOutputStream, this.value);
        this.time.serialize(dataOutputStream);
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.recipient = Set.deserializeUUID(dataInputStream);
        this.objectId = Set.deserializeUUID(dataInputStream);
        this.transactionId = Set.deserializeUUID(dataInputStream);
        this.key = dataInputStream.readUTF();
        this.value = this.deserializeObject(dataInputStream);
        this.time = new PseudoTime();
        this.time.deserialize(dataInputStream);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public PseudoTime getTime() {
        return this.time;
    }
}

