/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.net.data.time.PseudoTime;
import org.structr.net.peer.Peer;
import org.structr.net.peer.PeerInfo;
import org.structr.net.protocol.Message;
import org.structr.net.repository.Repository;
import org.structr.net.repository.RepositoryObject;

public class Update
extends Message {
    private static final Logger logger = LoggerFactory.getLogger((String)Update.class.getName());
    private final Map<String, Object> data = new HashMap<String, Object>();
    private PseudoTime created = null;
    private PseudoTime lastModified = null;
    private String objectId = null;
    private String userId = null;
    private String type = null;

    public Update() {
        this(null, null, null, null, null, null, null);
    }

    public Update(String string, String string2, String string3, String string4, PseudoTime pseudoTime, PseudoTime pseudoTime2, Map<String, Object> map) {
        super(4, string);
        this.objectId = string2;
        this.userId = string4;
        this.type = string3;
        this.created = pseudoTime;
        this.lastModified = pseudoTime2;
        if (map != null) {
            this.data.putAll(map);
        }
    }

    @Override
    public void onMessage(Peer peer, PeerInfo peerInfo) {
        Repository repository = peer.getRepository();
        RepositoryObject repositoryObject = repository.getObject(this.objectId);
        if (repositoryObject != null) {
            repository.update(repositoryObject, this.type, this.objectId, this.userId, this.lastModified, this.data);
        } else {
            repository.objectCreated(this.objectId, this.type, this.getSender(), this.userId, this.created, this.lastModified, this.data);
        }
    }

    @Override
    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        super.serialize(dataOutputStream);
        Update.serializeUUID(dataOutputStream, this.objectId);
        dataOutputStream.writeUTF(this.userId);
        dataOutputStream.writeUTF(this.type);
        this.created.serialize(dataOutputStream);
        this.lastModified.serialize(dataOutputStream);
        int n = this.data.size();
        dataOutputStream.writeInt(n);
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            this.serializeObject(dataOutputStream, entry.getValue());
        }
    }

    @Override
    public void deserialize(DataInputStream dataInputStream) throws IOException {
        super.deserialize(dataInputStream);
        this.objectId = Update.deserializeUUID(dataInputStream);
        this.userId = dataInputStream.readUTF();
        this.type = dataInputStream.readUTF();
        this.created = PseudoTime.fromStream(dataInputStream);
        this.lastModified = PseudoTime.fromStream(dataInputStream);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                String string = dataInputStream.readUTF();
                Object object = this.deserializeObject(dataInputStream);
                this.data.put(string, object);
                continue;
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PseudoTime getTime() {
        return this.created;
    }
}

