/*
 * Decompiled with CFR 0.152.
 */
package org.structr.net.repository;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.structr.net.data.time.Clock;
import org.structr.net.repository.DefaultRepositoryObject;

public class DefaultPossibility {
    private static final long DEFAULT_TIMEOUT = 10000L;
    private Set<DefaultRepositoryObject> objects = new HashSet<DefaultRepositoryObject>();
    private String uuid = null;
    private State state = State.Waiting;
    private Clock clock = null;
    private long timeout = 0L;

    public DefaultPossibility(Clock clock) {
        this(clock, UUID.randomUUID().toString().replaceAll("\\-", ""));
    }

    public DefaultPossibility(Clock clock, long l) {
        this(clock, UUID.randomUUID().toString().replaceAll("\\-", ""), l);
    }

    public DefaultPossibility(Clock clock, String string) {
        this(clock, string, 10000L);
    }

    public DefaultPossibility(Clock clock, String string, long l) {
        this(clock, string, l, State.Waiting);
    }

    public DefaultPossibility(Clock clock, String string, long l, State state) {
        this.clock = clock;
        this.state = state;
        this.uuid = string;
        this.timeout = clock.getTime() + l;
    }

    public String toString() {
        return "DefaultPossibility(" + this.uuid + ", " + (Object)((Object)this.state) + ")";
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isComplete() {
        if (State.Completed.equals((Object)this.state)) {
            return true;
        }
        if (this.isTimedOut()) {
            this.state = State.Aborted;
        }
        return false;
    }

    public boolean isAborted() {
        return State.Aborted.equals((Object)this.state);
    }

    public void complete() {
        if (this.isTimedOut()) {
            this.state = State.Aborted;
        } else if (State.Waiting.equals((Object)this.state)) {
            this.state = State.Completed;
            for (DefaultRepositoryObject defaultRepositoryObject : this.objects) {
                defaultRepositoryObject.onCommit(this.uuid);
            }
        }
    }

    public void addObject(DefaultRepositoryObject defaultRepositoryObject) {
        this.objects.add(defaultRepositoryObject);
    }

    private boolean isTimedOut() {
        return this.clock.getTime() > this.timeout;
    }

    public static enum State {
        Waiting,
        Completed,
        Aborted;

    }
}

