/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.service.Command;
import org.structr.api.service.RunnableService;
import org.structr.api.service.StructrServices;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.ldap.LDAPUser;

public class LDAPService
extends Thread
implements RunnableService {
    private static final Logger logger = LoggerFactory.getLogger((String)LDAPService.class.getName());
    public static final String CONFIG_KEY_UPDATE_INTERVAL = "ldap.updateInterval";
    public static final String CONFIG_KEY_LDAP_BINDDN = "ldap.bindDn";
    public static final String CONFIG_KEY_LDAP_SECRET = "ldap.secret";
    public static final String CONFIG_KEY_LDAP_HOST = "ldap.host";
    public static final String CONFIG_KEY_LDAP_PORT = "ldap.port";
    public static final String CONFIG_KEY_LDAP_SSL = "ldap.useSsl";
    public static final String CONFIG_KEY_LDAP_BASEDN = "ldap.baseDn";
    public static final String CONFIG_KEY_LDAP_FILTER = "ldap.filter";
    public static final String CONFIG_KEY_LDAP_SCOPE = "ldap.scope";
    private long updateInterval = TimeUnit.HOURS.toMillis(2L);
    private String host = "localhost";
    private String binddn = null;
    private String secret = null;
    private String baseDn = null;
    private String filter = null;
    private String scope = null;
    private boolean useSsl = true;
    private boolean doRun = false;
    private int port = 389;

    public LDAPService() {
        super("Structr LDAP Service");
        this.setDaemon(true);
    }

    public String fetchObjectInfo(String string) {
        LdapNetworkConnection ldapNetworkConnection = new LdapNetworkConnection(this.host, this.port, this.useSsl);
        StringBuilder stringBuilder = new StringBuilder();
        if (ldapNetworkConnection != null) {
            try {
                if (ldapNetworkConnection.connect()) {
                    if (StringUtils.isNotBlank((String)this.binddn) && StringUtils.isNotBlank((String)this.secret)) {
                        ldapNetworkConnection.bind(this.binddn, this.secret);
                    } else if (StringUtils.isNotBlank((String)this.binddn)) {
                        ldapNetworkConnection.bind(this.binddn);
                    }
                    EntryCursor entryCursor = ldapNetworkConnection.search(string, "(objectclass=*)", SearchScope.OBJECT, new String[0]);
                    while (entryCursor.next()) {
                        stringBuilder.append(entryCursor.get());
                        stringBuilder.append("\n");
                    }
                    entryCursor.close();
                    ldapNetworkConnection.close();
                }
                ldapNetworkConnection.close();
            }
            catch (IOException | CursorException | LdapException throwable) {
                logger.warn("", throwable);
            }
        }
        return stringBuilder.toString();
    }

    public boolean canSuccessfullyBind(String string, String string2) {
        LdapNetworkConnection ldapNetworkConnection = new LdapNetworkConnection(this.host, this.port, this.useSsl);
        if (ldapNetworkConnection != null) {
            try {
                if (ldapNetworkConnection.connect()) {
                    ldapNetworkConnection.bind(string, string2);
                    ldapNetworkConnection.unBind();
                }
                ldapNetworkConnection.close();
                return true;
            }
            catch (IOException | LdapException throwable) {
                logger.warn("", throwable);
            }
        }
        return false;
    }

    public void doUpdate() throws IOException, LdapException, CursorException, FrameworkException {
        LdapNetworkConnection ldapNetworkConnection = new LdapNetworkConnection(this.host, this.port, this.useSsl);
        App app = StructrApp.getInstance();
        if (ldapNetworkConnection != null) {
            ldapNetworkConnection.setTimeOut(0L);
            if (ldapNetworkConnection.connect()) {
                Tx tx;
                logger.info("Updating user/group information from LDAP server {}:{}..", new Object[]{this.host, this.port});
                if (StringUtils.isNotBlank((String)this.binddn) && StringUtils.isNotBlank((String)this.secret)) {
                    ldapNetworkConnection.bind(this.binddn, this.secret);
                } else if (StringUtils.isNotBlank((String)this.binddn)) {
                    ldapNetworkConnection.bind(this.binddn);
                }
                EntryCursor entryCursor = ldapNetworkConnection.search(this.baseDn, this.filter, SearchScope.valueOf((String)this.scope), new String[0]);
                while (entryCursor.next()) {
                    tx = (Entry)entryCursor.get();
                    this.synchronizeUserEntry((LdapConnection)ldapNetworkConnection, (Entry)tx);
                }
                tx = app.tx();
                Throwable throwable = null;
                try {
                    for (LDAPUser lDAPUser : app.nodeQuery(LDAPUser.class).getAsList()) {
                        String string = (String)lDAPUser.getProperty((PropertyKey)LDAPUser.distinguishedName);
                        if (string != null) {
                            Entry entry = ldapNetworkConnection.lookup(string);
                            if (entry != null) {
                                lDAPUser.initializeFrom(entry);
                                continue;
                            }
                            logger.info("User {} doesn't exist in LDAP directory, deleting.", (Object)lDAPUser);
                            app.delete((NodeInterface)lDAPUser);
                            continue;
                        }
                        logger.warn("User {} doesn't have an LDAP distinguished name, ignoring.", (Object)lDAPUser);
                    }
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                entryCursor.close();
                ldapNetworkConnection.close();
            } else {
                logger.info("Connection to LDAP server {} failed", (Object)this.host);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String synchronizeUserEntry(LdapConnection ldapConnection, Entry entry) {
        App app = StructrApp.getInstance();
        Dn dn = entry.getDn();
        String string2 = dn.toString();
        try (Tx tx = app.tx();){
            String string;
            LDAPUser lDAPUser = (LDAPUser)app.nodeQuery(LDAPUser.class).and(LDAPUser.distinguishedName, (Object)string2).getFirst();
            if (lDAPUser == null) {
                lDAPUser = (LDAPUser)app.create(LDAPUser.class, new NodeAttribute[]{new NodeAttribute(LDAPUser.distinguishedName, (Object)string2)});
                lDAPUser.initializeFrom(entry);
                string = lDAPUser.getUuid();
                if (lDAPUser.getProperty((PropertyKey)LDAPUser.entryUuid) == null) {
                    try {
                        DefaultModification defaultModification = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "entryUUID", new String[]{this.normalizeUUID(string)});
                        ldapConnection.modify(dn, new Modification[]{defaultModification});
                    }
                    catch (LdapException ldapException) {
                        logger.warn("Unable to set entryUUID: {}", (Object)ldapException.getMessage());
                    }
                }
            }
            tx.success();
            string = lDAPUser.getUuid();
            return string;
        }
        catch (LdapInvalidAttributeValueException | FrameworkException throwable6) {
            logger.warn("Unable to update LDAP information", throwable6);
            return null;
        }
    }

    @Override
    public void run() {
        this.doRun = true;
        while (!Services.getInstance().isInitialized()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.doRun) {
            try {
                this.doUpdate();
            }
            catch (Throwable throwable) {
                logger.warn("Unable to update LDAP information", throwable);
            }
            try {
                Thread.sleep(this.updateInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startService() throws Exception {
        logger.info("Starting LDAPService, update interval {} s", (Object)TimeUnit.MILLISECONDS.toSeconds(this.updateInterval));
        this.start();
    }

    public void stopService() {
        this.doRun = false;
    }

    public boolean runOnStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.doRun;
    }

    public void injectArguments(Command command) {
    }

    public void initialize(StructrServices structrServices) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.updateInterval = ((Integer)Settings.getOrCreateIntegerSetting((String[])new String[]{CONFIG_KEY_UPDATE_INTERVAL, Long.toString(TimeUnit.HOURS.toMillis(2L))}).getValue()).intValue();
        this.binddn = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_BINDDN}).getValue();
        this.secret = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_SECRET}).getValue();
        this.host = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_HOST, "localhost"}).getValue();
        this.baseDn = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_BASEDN, "ou=system"}).getValue();
        this.filter = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_FILTER, "(objectclass=*)"}).getValue();
        this.scope = (String)Settings.getOrCreateStringSetting((String[])new String[]{CONFIG_KEY_LDAP_SCOPE, "SUBTREE"}).getValue();
        this.port = (Integer)Settings.getOrCreateIntegerSetting((String[])new String[]{CONFIG_KEY_LDAP_PORT}).getValue((Object)339);
        this.useSsl = (Boolean)Settings.getBooleanSetting((String[])new String[]{CONFIG_KEY_LDAP_SSL}).getValue((Object)true);
    }

    public void shutdown() {
        this.doRun = false;
    }

    public void initialized() {
    }

    public boolean isVital() {
        return false;
    }

    public String getModuleName() {
        return "ldap-client";
    }

    private String normalizeUUID(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.insert(8, "-");
        stringBuilder.insert(13, "-");
        stringBuilder.insert(18, "-");
        stringBuilder.insert(23, "-");
        return stringBuilder.toString();
    }
}

