/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.Services;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.ldap.LDAPService;
import org.structr.web.entity.User;

public class LDAPUser
extends User {
    private static final Logger logger = LoggerFactory.getLogger(LDAPUser.class);
    public static final Property<String> distinguishedName = new StringProperty("distinguishedName").unique().indexed();
    public static final Property<String> description = new StringProperty("description").indexed();
    public static final Property<String> commonName = new StringProperty("commonName").indexed();
    public static final Property<String> entryUuid = new StringProperty("entryUuid").unique().indexed();
    public static final View uiView = new View(LDAPUser.class, "ui", new Property[]{distinguishedName, entryUuid, commonName, description});
    public static final View publicView = new View(LDAPUser.class, "public", new Property[]{distinguishedName, entryUuid, commonName, description});

    public void initializeFrom(Entry entry) throws FrameworkException, LdapInvalidAttributeValueException {
        this.setProperty((PropertyKey)description, this.getString(entry, "description"));
        this.setProperty((PropertyKey)entryUuid, this.getString(entry, "entryUUID"));
        this.setProperty((PropertyKey)name, this.getString(entry, "uid"));
        this.setProperty((PropertyKey)commonName, this.getString(entry, "cn"));
        this.setProperty((PropertyKey)eMail, this.getString(entry, "mail"));
    }

    public boolean isValidPassword(String string) {
        LDAPService lDAPService = (LDAPService)Services.getInstance().getService(LDAPService.class);
        String string2 = (String)this.getProperty((PropertyKey)distinguishedName);
        if (lDAPService != null) {
            return lDAPService.canSuccessfullyBind(string2, string);
        }
        logger.warn("Unable to reach LDAP server for authentication of {}", (Object)string2);
        return false;
    }

    @Export
    public void printDebug() {
        LDAPService lDAPService = (LDAPService)Services.getInstance().getService(LDAPService.class);
        String string = (String)this.getProperty((PropertyKey)distinguishedName);
        if (lDAPService != null) {
            System.out.println(lDAPService.fetchObjectInfo(string));
        } else {
            logger.warn("Unable to reach LDAP server for user information of {}", (Object)string);
        }
    }

    private String getString(Entry entry, String string) throws LdapInvalidAttributeValueException {
        Attribute attribute = entry.get(string);
        if (attribute != null) {
            return attribute.getString();
        }
        return null;
    }
}

