/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterAttribute<T>
extends Attribute {
    private static final L10N L = new L10N(SetterAttribute.class);
    private final Method _setter;
    private final Class<T> _type;
    private ConfigType<T> _configType;

    public SetterAttribute(Method setter, Class<T> type) {
        this._setter = setter;
        this._setter.setAccessible(true);
        this._type = type;
    }

    public ConfigType<T> getConfigType() {
        if (this._configType == null) {
            this._configType = TypeFactory.getType(this._type);
        }
        return this._configType;
    }

    @Override
    public boolean isAllowText() {
        return this.getConfigType().isConstructableFromString();
    }

    @Override
    public boolean isAllowInline() {
        return true;
    }

    @Override
    public boolean isInlineType(ConfigType<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isReplace()) {
            return true;
        }
        if (this.getConfigType().isInlineType(type)) {
            return true;
        }
        if (type.isQualifier()) {
            return true;
        }
        return this._type.isAssignableFrom(type.getType());
    }

    @Override
    public boolean isConfigurable() {
        return this._setter.isAnnotationPresent(Configurable.class);
    }

    @Override
    public boolean isAssignableFrom(Attribute attr) {
        if (!(attr instanceof SetterAttribute)) {
            return false;
        }
        SetterAttribute setterAttr = (SetterAttribute)attr;
        Method setter = setterAttr._setter;
        if (!this._setter.getName().equals(setter.getName())) {
            return false;
        }
        return this._setter.getDeclaringClass().isAssignableFrom(setter.getDeclaringClass());
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        try {
            ConfigType<T> configType = this.getConfigType();
            this._setter.invoke(bean, configType.valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            this._setter.invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            throw ConfigException.create(this._setter, L.l("'{0}' is an illegal value.", value), e);
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public Object create(Object parent, QName name, ConfigType<?> configType) throws ConfigException {
        try {
            if (configType != null && this._type.isAssignableFrom(configType.getType())) {
                return configType.create(parent, name);
            }
            return this.getConfigType().create(parent, name);
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public Object create(Object parent, QName name) throws ConfigException {
        try {
            return this.getConfigType().create(parent, name);
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SetterAttribute attr = (SetterAttribute)o;
        return this._type.equals(attr._type) && this._setter.equals(attr._setter);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._setter + "]";
    }
}

