/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAttribute<T>
extends Attribute {
    private final Method _setter;
    private final Class<T> _type;
    private ConfigType<T> _configType;

    public TextAttribute(Method setter, Class<T> type) {
        this._setter = setter;
        this._type = type;
    }

    public ConfigType<T> getConfigType() {
        if (this._configType == null) {
            this._configType = TypeFactory.getType(this._type);
        }
        return this._configType;
    }

    @Override
    public boolean isAssignableFrom(Attribute attr) {
        if (!(attr instanceof TextAttribute)) {
            return false;
        }
        TextAttribute textAttr = (TextAttribute)attr;
        Method setter = textAttr._setter;
        if (!this._setter.getName().equals(setter.getName())) {
            return false;
        }
        return this._setter.getDeclaringClass().isAssignableFrom(setter.getDeclaringClass());
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        try {
            this._setter.invoke(bean, this.getConfigType().valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            this._setter.invoke(bean, value);
        }
        catch (Exception e) {
            throw ConfigException.create(this._setter, (Throwable)e);
        }
    }

    @Override
    public Object create(Object parent, QName name) throws ConfigException {
        return null;
    }
}

