/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.inject.QualifierBinding;
import com.caucho.config.reflect.BaseType;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverEntry<T> {
    private ObserverMethod<T> _observer;
    private BaseType _type;
    private QualifierBinding[] _qualifiers;

    ObserverEntry(ObserverMethod<T> observer, BaseType type, Annotation[] qualifiers) {
        this._observer = observer;
        this._type = type;
        this._qualifiers = new QualifierBinding[qualifiers.length];
        for (int i = 0; i < qualifiers.length; ++i) {
            this._qualifiers[i] = new QualifierBinding(qualifiers[i]);
        }
    }

    ObserverMethod<T> getObserver() {
        return this._observer;
    }

    BaseType getType() {
        return this._type;
    }

    void notify(T event) {
        this._observer.notify(event);
    }

    void fireEvent(T event, Annotation[] qualifiers) {
        if (this.isMatch(qualifiers)) {
            this._observer.notify(event);
        }
    }

    void resolveObservers(Set<ObserverMethod<?>> set, Annotation[] qualifiers) {
        if (this.isMatch(qualifiers)) {
            set.add(this._observer);
        }
    }

    boolean isAssignableFrom(BaseType type, Annotation[] qualifiers) {
        if (!this._type.isAssignableFrom(type)) {
            return false;
        }
        return this.isMatch(qualifiers);
    }

    private boolean isMatch(Annotation[] qualifiers) {
        for (QualifierBinding qualifier : this._qualifiers) {
            if (qualifier.isAny() || qualifier.isMatch(qualifiers)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._observer + "," + this._type + "]";
    }
}

