/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.reflect.BaseTypeAnnotated;
import com.caucho.config.reflect.VarType;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.ApplicationException;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class AbstractAspectGenerator<X>
implements AspectGenerator<X> {
    private AspectFactory<X> _factory;
    private AnnotatedMethod<? super X> _method;
    private AspectGenerator<X> _next;

    protected AbstractAspectGenerator(AspectFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        this._factory = factory;
        this._method = method;
        this._next = next;
        if (next == null) {
            throw new NullPointerException();
        }
    }

    protected AspectFactory<X> getFactory() {
        return this._factory;
    }

    protected AspectBeanFactory<X> getBeanFactory() {
        return this._factory.getAspectBeanFactory();
    }

    protected String getInstanceName() {
        return this.getBeanFactory().getBeanInstance();
    }

    protected AnnotatedType<X> getBeanType() {
        return this._factory.getBeanType();
    }

    protected Class<X> getJavaClass() {
        return this.getBeanType().getJavaClass();
    }

    @Override
    public AnnotatedMethod<? super X> getMethod() {
        return this._method;
    }

    protected Set<VarType<?>> getTypeVariables() {
        AnnotatedMethod<X> method = this.getMethod();
        if (method instanceof BaseTypeAnnotated) {
            BaseTypeAnnotated annType = (BaseTypeAnnotated)this.getMethod();
            Set<VarType<?>> varSet = annType.getTypeVariables();
            return varSet;
        }
        return new HashSet();
    }

    protected Method getJavaMethod() {
        return this._method.getJavaMember();
    }

    @Override
    public void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected void generateContent(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this.generatePreTry(out);
        out.println();
        out.println("try {");
        out.pushDepth();
        AnnotatedMethod<X> method = this.getMethod();
        if (!Void.TYPE.equals(method.getBaseType())) {
            out.printType(method.getBaseType());
            out.println(" result;");
        }
        this.generatePreCall(out);
        this.generateCall(out);
        this.generatePostCall(out);
        if (!Void.TYPE.equals(method.getBaseType())) {
            out.println("return result;");
        }
        out.popDepth();
        this.generateExceptions(out);
        out.println("} finally {");
        out.pushDepth();
        this.generateFinally(out);
        out.popDepth();
        out.println("}");
        this.generatePostFinally(out);
    }

    private void generateExceptions(JavaWriter out) throws IOException {
        Class<?> exn;
        if (!this.isApplicationExceptionThrown()) {
            return;
        }
        HashSet exceptionSet = new HashSet();
        for (Class<?> exn2 : this.getThrowsExceptions()) {
            exceptionSet.add(exn2);
        }
        exceptionSet.add(RuntimeException.class);
        exceptionSet.add(Error.class);
        while ((exn = this.selectException(exceptionSet)) != null) {
            boolean isSystemException = (RuntimeException.class.isAssignableFrom(exn) || Error.class.isAssignableFrom(exn)) && !exn.isAnnotationPresent(ApplicationException.class);
            out.print("} catch (");
            out.printClass(exn);
            out.println(" e) {");
            out.pushDepth();
            if (isSystemException) {
                this.generateSystemException(out, exn);
            } else {
                this.generateApplicationException(out, exn);
            }
            out.println();
            out.println("throw e;");
            out.popDepth();
        }
    }

    private Class<?> selectException(HashSet<Class<?>> exnSet) {
        for (Class<?> exn : exnSet) {
            if (!this.isMostSpecific(exn, exnSet)) continue;
            exnSet.remove(exn);
            return exn;
        }
        return null;
    }

    private boolean isMostSpecific(Class<?> exn, HashSet<Class<?>> exnSet) {
        for (Class<?> testExn : exnSet) {
            if (exn == testExn || !exn.isAssignableFrom(testExn)) continue;
            return false;
        }
        return true;
    }

    protected Class<?>[] getThrowsExceptions() {
        return this.getJavaMethod().getExceptionTypes();
    }

    @Override
    public void generateBeanPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateBeanPrologue(out, map);
    }

    @Override
    public void generateBeanConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateBeanConstructor(out, map);
    }

    @Override
    public void generateProxyConstructor(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateProxyConstructor(out, map);
    }

    @Override
    public void generateInject(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateInject(out, map);
    }

    @Override
    public void generatePostConstruct(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generatePostConstruct(out, map);
    }

    @Override
    public void generatePreDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generatePreDestroy(out, map);
    }

    @Override
    public void generateEpilogue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateEpilogue(out, map);
    }

    @Override
    public void generateDestroy(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateDestroy(out, map);
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        this._next.generateMethodPrologue(out, map);
    }

    @Override
    public void generateAsync(JavaWriter out) throws IOException {
        this._next.generateAsync(out);
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        this._next.generatePreTry(out);
    }

    @Override
    public void generatePreCall(JavaWriter out) throws IOException {
        this._next.generatePreCall(out);
    }

    @Override
    public void generateCall(JavaWriter out) throws IOException {
        this._next.generateCall(out);
    }

    @Override
    public void generatePostCall(JavaWriter out) throws IOException {
        this._next.generatePostCall(out);
    }

    @Override
    public boolean isApplicationExceptionThrown() {
        return this._next.isApplicationExceptionThrown();
    }

    @Override
    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
        this._next.generateApplicationException(out, exn);
    }

    @Override
    public void generateSystemException(JavaWriter out, Class<?> exn) throws IOException {
        this._next.generateSystemException(out, exn);
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        this._next.generateFinally(out);
    }

    @Override
    public void generatePostFinally(JavaWriter out) throws IOException {
        this._next.generatePostFinally(out);
    }

    protected <Z extends Annotation> Z getAnnotation(Class<Z> annotationType, AnnotatedMethod<?> apiMethod, AnnotatedMethod<?> implMethod) {
        Annotation annotation = apiMethod.getAnnotation(annotationType);
        if (annotation == null && implMethod != null) {
            annotation = implMethod.getAnnotation(annotationType);
        }
        return (Z)annotation;
    }

    protected <Z extends Annotation> Z getAnnotation(Class<Z> annotationType, AnnotatedType<?> apiClass, AnnotatedType<?> implClass) {
        Annotation annotation = null;
        if (apiClass != null) {
            annotation = apiClass.getAnnotation(annotationType);
        }
        if (annotation == null && implClass != null) {
            annotation = implClass.getAnnotation(annotationType);
        }
        return (Z)annotation;
    }

    protected <Z extends Annotation> Z getAnnotation(Class<Z> annotationType, AnnotatedMethod<?> apiMethod, AnnotatedType<?> apiClass, AnnotatedMethod<?> implementationMethod, AnnotatedType<?> implementationClass) {
        Annotation annotation = null;
        if (apiMethod != null) {
            annotation = apiMethod.getAnnotation(annotationType);
        }
        if (annotation == null && apiClass != null) {
            annotation = apiClass.getAnnotation(annotationType);
        }
        if (annotation == null && implementationMethod != null) {
            annotation = implementationMethod.getAnnotation(annotationType);
        }
        if (annotation == null && implementationClass != null) {
            annotation = implementationClass.getAnnotation(annotationType);
        }
        return (Z)annotation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._method + "]";
    }
}

