/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.j2ee.JpaPersistenceContextLiteral;
import com.caucho.config.j2ee.WebBeanGenerator;
import com.caucho.util.L10N;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextGenerator
extends WebBeanGenerator {
    private static final Logger log = Logger.getLogger(PersistenceContextGenerator.class.getName());
    private static final L10N L = new L10N(PersistenceContextGenerator.class);
    private String _location;
    private String _jndiName;
    private String _unitName;
    private PersistenceContextType _type;
    private Map _properties;
    private EntityManager _manager;

    PersistenceContextGenerator(String location, String jndiName, String unitName, PersistenceContextType type, Map properties) {
        this._location = location;
        this._jndiName = jndiName;
        this._unitName = unitName;
        this._type = type;
        this._properties = properties;
    }

    PersistenceContextGenerator(String location, PersistenceContext pc) {
        this._location = location;
        this._jndiName = pc.name();
        this._unitName = pc.unitName();
        this._type = pc.type();
        this._properties = new HashMap();
        PersistenceProperty[] propertyList = pc.properties();
        for (int i = 0; propertyList != null && i < propertyList.length; ++i) {
            PersistenceProperty prop = propertyList[i];
            this._properties.put(prop.name(), prop.value());
        }
    }

    @Override
    public Class<?> getType() {
        return EntityManager.class;
    }

    @Override
    public Object create() {
        if (this._manager != null) {
            return this._manager;
        }
        try {
            this._manager = PersistenceContextType.EXTENDED.equals((Object)this._type) ? this.create(EntityManager.class, new JpaPersistenceContextLiteral(this._unitName, true)) : this.create(EntityManager.class, new JpaPersistenceContextLiteral(this._unitName));
        }
        catch (Exception e) {
            throw ConfigException.create(this._location, (Throwable)e);
        }
        return this._manager;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jndiName + "," + this._unitName + "]";
    }
}

