/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.AbstractInjectionPoint;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class PostConstructProgram
extends ConfigProgram {
    private AnnotatedMethod<?> _annMethod;
    private Method _init;
    private ParamProgram[] _program;

    public PostConstructProgram(AnnotatedMethod<?> annMethod, Method init) {
        this._annMethod = annMethod;
        this._init = init;
        this._init.setAccessible(true);
        this.introspect();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._init.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this._init.getName();
    }

    public AnnotatedMethod<?> getAnnotatedMethod() {
        return this._annMethod;
    }

    protected void introspect() {
        Type[] paramTypes = this._init.getGenericParameterTypes();
        if (paramTypes.length == 0) {
            return;
        }
        this._program = new ParamProgram[paramTypes.length];
        Annotation[][] paramAnns = this._init.getParameterAnnotations();
        InjectManager webBeans = InjectManager.create();
        for (int i = 0; i < paramTypes.length; ++i) {
            Annotation[] bindings = this.createBindings(paramAnns[i]);
            this._program[i] = new ParamProgram(webBeans, paramTypes[i], bindings, paramAnns[i]);
        }
    }

    Annotation[] createBindings(Annotation[] annotations) {
        ArrayList<Annotation> bindingList = new ArrayList<Annotation>();
        for (Annotation ann : annotations) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            bindingList.add(ann);
        }
        if (bindingList.size() == 0) {
            return null;
        }
        Annotation[] bindings = new Annotation[bindingList.size()];
        bindingList.toArray(bindings);
        return bindings;
    }

    @Override
    public <T> void inject(T bean, CreationalContext<T> env) throws ConfigException {
        try {
            if (this._program != null) {
                Object[] args = new Object[this._program.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this._program[i].eval(env);
                }
                this._init.invoke(bean, args);
            } else {
                this._init.invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(this._init, (Throwable)e);
        }
    }

    public int hashCode() {
        return this._init.getName().hashCode();
    }

    public boolean equals(Object o) {
        Class<?>[] bParam;
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostConstructProgram)) {
            return false;
        }
        PostConstructProgram program = (PostConstructProgram)o;
        Method init = program._init;
        if (!this._init.getName().equals(init.getName())) {
            return false;
        }
        if (!init.getDeclaringClass().equals(this._init.getDeclaringClass())) {
            return false;
        }
        Class<?>[] aParam = this._init.getParameterTypes();
        if (aParam.length != (bParam = init.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < aParam.length; ++i) {
            if (aParam[i].equals(bParam[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._init + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParamProgram {
        private final InjectManager _inject;
        private final AbstractInjectionPoint _injectionPoint;

        ParamProgram(InjectManager inject, Type type, Annotation[] bindings, Annotation[] annList) {
            this._inject = inject;
            Bean bean = null;
            Member member = null;
            HashSet<Annotation> bindingSet = new HashSet<Annotation>();
            if (bindings != null) {
                for (Annotation ann : bindings) {
                    bindingSet.add(ann);
                }
            } else {
                bindingSet.add((Annotation)CurrentLiteral.CURRENT);
            }
            this._injectionPoint = new AbstractInjectionPoint(inject, bean, member, type, bindingSet, annList);
        }

        public Object eval(CreationalContext<?> env) {
            return this._inject.getInjectableReference(this._injectionPoint, env);
        }
    }
}

