/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.FlowAttribute;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.el.Expr;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Constructor;
import javax.el.ELContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigType<T> {
    private static final L10N L = new L10N(ConfigType.class);
    private boolean _isEnvBean;
    private boolean _isIntrospected;

    public abstract Class<T> getType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void carefulIntrospect() {
        if (this._isIntrospected) {
            return;
        }
        ConfigType configType = this;
        synchronized (configType) {
            if (!this._isIntrospected) {
                this.introspect();
            }
            this._isIntrospected = true;
        }
    }

    public void introspect() {
    }

    public String getTypeName() {
        return this.getType().getName();
    }

    public Object create(Object parent, QName name) {
        return null;
    }

    public ConfigType<?> createType(QName name) {
        return null;
    }

    public ConfigType<?> getType(Object childBean) {
        return TypeFactory.getType(childBean);
    }

    public void inject(Object bean) {
    }

    public void init(Object bean) {
    }

    public Object replaceObject(Object bean) {
        return bean;
    }

    public Constructor<?> getConstructor(int count) {
        throw new ConfigException(L.l("'{0}' does not support <new> constructors", (Object)this));
    }

    public abstract Object valueOf(String var1);

    public Object valueOf(Object value) {
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        return value;
    }

    public Object valueOf(ELContext env, Expr value) {
        return this.valueOf(value.getValue(env));
    }

    public boolean isBean() {
        return false;
    }

    public boolean isNode() {
        return false;
    }

    public boolean isNoTrim() {
        return false;
    }

    public boolean isEL() {
        return true;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isReplace() {
        return false;
    }

    public boolean isQualifier() {
        return false;
    }

    public boolean isProgram() {
        return false;
    }

    public ConfigType<?> getComponentType() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Attribute getDefaultAttribute(QName qName) {
        Attribute attrStrategy = this.getProgramAttribute();
        if (attrStrategy != null) {
            return attrStrategy;
        }
        attrStrategy = this.getContentProgramAttribute();
        TypeFactory factory = TypeFactory.getFactory();
        Attribute envStrategy = factory.getEnvironmentAttribute(qName);
        if (envStrategy instanceof FlowAttribute || envStrategy != null && attrStrategy == null) {
            return envStrategy;
        }
        if (attrStrategy != null) {
            return attrStrategy;
        }
        if (qName.getNamespaceURI() != null && qName.getNamespaceURI().startsWith("urn:java:")) {
            return this.getAddBeanAttribute(qName);
        }
        return null;
    }

    public Attribute getAddBeanAttribute(QName qName) {
        return null;
    }

    public Attribute getAttribute(QName qName) {
        return null;
    }

    public boolean setProperty(Object bean, QName name, Object value) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setValue(bean, name, attr.getConfigType().valueOf(value));
            return true;
        }
        return false;
    }

    public Attribute getProgramAttribute() {
        return null;
    }

    public Attribute getContentProgramAttribute() {
        return null;
    }

    public Attribute getAddAttribute(Class<?> cl) {
        return null;
    }

    public void beforeConfigureBean(XmlConfigContext builder, Object bean, Node node) {
    }

    public void beforeConfigure(XmlConfigContext builder, Object bean, Node node) {
    }

    public void afterConfigure(XmlConfigContext builder, Object bean) {
    }

    public boolean isConstructableFromString() {
        return true;
    }

    public boolean isInlineType(ConfigType<?> type) {
        return false;
    }

    public boolean isEnvBean() {
        return this._isEnvBean;
    }

    public void setEnvBean(boolean isEnvBean) {
        this._isEnvBean = isEnvBean;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTypeName() + "]";
    }
}

