/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.TagName;
import com.caucho.config.annotation.DisableConfig;
import com.caucho.config.annotation.NonEL;
import com.caucho.config.attribute.AddAttribute;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.CreateAttribute;
import com.caucho.config.attribute.ProgramAttribute;
import com.caucho.config.attribute.PropertyAttribute;
import com.caucho.config.attribute.SetterAttribute;
import com.caucho.config.attribute.TextAttribute;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.PropertyStringProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.EnvBean;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.RawString;
import com.caucho.config.xml.XmlBeanAttribute;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.PersistentDependency;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineBeanType<T>
extends ConfigType<T> {
    private static final L10N L = new L10N(InlineBeanType.class);
    private static final Logger log = Logger.getLogger(InlineBeanType.class.getName());
    private static final String RESIN_NS = "http://caucho.com/ns/resin";
    public static final QName TEXT = new QName("#text");
    public static final QName VALUE = new QName("value");
    private static final Object _introspectLock = new Object();
    private final Class<T> _beanClass;
    private ConcurrentHashMap<QName, Attribute> _nsAttributeMap = new ConcurrentHashMap();
    private HashMap<String, Attribute> _attributeMap = new HashMap();
    private Constructor<T> _stringConstructor;
    private Method _valueOf;
    private Method _setParent;
    private Method _replaceObject;
    private Method _setConfigLocation;
    private Method _setConfigUriLocation;
    private Method _setConfigNode;
    private Attribute _addText;
    private Attribute _addProgram;
    private Attribute _addContentProgram;
    private Attribute _addBean;
    private Attribute _setProperty;
    private boolean _isEL;
    private HashMap<Class<?>, Attribute> _addMethodMap = new HashMap();
    private Attribute _addCustomBean;
    private AnnotatedType<T> _annotatedType;
    private ManagedBeanImpl<T> _bean;
    private InjectionTarget<T> _injectionTarget;
    private ArrayList<ConfigProgram> _initList;
    private boolean _isIntrospecting;
    private boolean _isIntrospected;
    private ArrayList<InlineBeanType<?>> _pendingChildList = new ArrayList();

    public InlineBeanType(Class<T> beanClass) {
        this._beanClass = beanClass;
        if (EnvBean.class.isAssignableFrom(beanClass)) {
            this.setEnvBean(true);
        }
    }

    @Override
    public Class<T> getType() {
        return this._beanClass;
    }

    @Override
    public boolean isEL() {
        return this._isEL;
    }

    protected void setAddCustomBean(Attribute addCustomBean) {
        this._addCustomBean = addCustomBean;
    }

    protected void setAddAnnotation(Attribute addAnnotation) {
    }

    @Override
    public Object create(Object parent, QName name) {
        try {
            if (this._injectionTarget == null) {
                if (this._beanClass.isInterface()) {
                    throw new ConfigException(L.l("{0} cannot be instantiated because it is an interface", (Object)this._beanClass.getName()));
                }
                AnnotatedType<T> type = this.getAnnotatedType();
                InjectManager cdiManager = InjectManager.create(this._beanClass.getClassLoader());
                InjectionTargetBuilder<T> builder = new InjectionTargetBuilder<T>(cdiManager, type);
                this._injectionTarget = builder;
            }
            InjectionTarget<T> injection = this._injectionTarget;
            OwnerCreationalContext<T> env = new OwnerCreationalContext<T>(this._bean);
            Object bean = injection.produce(env);
            injection.inject(bean, env);
            if (this._setParent != null && parent != null && this._setParent.getParameterTypes()[0].isAssignableFrom(parent.getClass())) {
                try {
                    this._setParent.invoke(bean, parent);
                }
                catch (IllegalArgumentException e) {
                    throw ConfigException.create(this._setParent, L.l("{0}: setParent value of '{1}' is not valid", bean, parent), e);
                }
                catch (Exception e) {
                    throw ConfigException.create(this._setParent, (Throwable)e);
                }
            }
            return bean;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private AnnotatedType<T> getAnnotatedType() {
        if (this._annotatedType == null) {
            InjectManager cdiManager = InjectManager.create(this._beanClass.getClassLoader());
            this._annotatedType = cdiManager.createAnnotatedType(this._beanClass);
        }
        return this._annotatedType;
    }

    @Override
    public Constructor<T> getConstructor(int count) {
        for (Constructor<?> ctor : this._beanClass.getConstructors()) {
            if (ctor.getParameterTypes().length != count) continue;
            return ctor;
        }
        throw new ConfigException(L.l("{0} does not have any constructor with {1} arguments", (Object)this, count));
    }

    @Override
    public void beforeConfigure(XmlConfigContext env, Object bean, Node node) {
        int line;
        super.beforeConfigure(env, bean, node);
        if (this._setConfigNode != null) {
            try {
                this._setConfigNode.invoke(bean, node);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._setConfigLocation != null && node instanceof QNode) {
            String filename = ((QNode)node).getFilename();
            line = ((QNode)node).getLine();
            try {
                this._setConfigLocation.invoke(bean, filename, line);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._setConfigUriLocation != null && node instanceof QNode) {
            String uri = ((QNode)node).getBaseURI();
            line = ((QNode)node).getLine();
            try {
                this._setConfigUriLocation.invoke(bean, uri, line);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (bean instanceof DependencyBean) {
            DependencyBean dependencyBean = (DependencyBean)bean;
            ArrayList<Dependency> dependencyList = env.getDependencyList();
            if (dependencyList != null) {
                for (Dependency depend : dependencyList) {
                    dependencyBean.addDependency((PersistentDependency)depend);
                }
            }
        }
    }

    @Override
    public Attribute getAttribute(QName name) {
        Attribute attr = this._nsAttributeMap.get(name);
        if (attr == null && (attr = this.getAttributeImpl(name)) != null) {
            this._nsAttributeMap.put(name, attr);
        }
        return attr;
    }

    protected Attribute getAttributeImpl(QName name) {
        Attribute attr = this._attributeMap.get(name.getLocalName());
        if (attr != null) {
            return attr;
        }
        String uri = name.getNamespaceURI();
        if (uri == null || !uri.startsWith("urn:java")) {
            return null;
        }
        Class<?> cl = this.createClass(name);
        if (cl != null && (attr = this.getAddAttribute(cl)) != null) {
            return attr;
        }
        ConfigType<?> envBean = TypeFactory.getFactory().getEnvironmentType(name);
        if (envBean != null && envBean.isEnvBean()) {
            return null;
        }
        if (this._addCustomBean != null) {
            return this._addCustomBean;
        }
        if (this._addBean != null) {
            return this._addBean;
        }
        return null;
    }

    @Override
    public Attribute getAddBeanAttribute(QName qName) {
        return this._addBean;
    }

    @Override
    public Attribute getAddAttribute(Class<?> cl) {
        if (cl == null) {
            return null;
        }
        Attribute attr = this._addMethodMap.get(cl);
        if (attr != null) {
            return attr;
        }
        for (Class<?> iface : cl.getInterfaces()) {
            attr = this.getAddAttribute(iface);
            if (attr == null) continue;
            return attr;
        }
        return this.getAddAttribute(cl.getSuperclass());
    }

    private Class<?> createClass(QName name) {
        String uri = name.getNamespaceURI();
        if (uri.equals(RESIN_NS)) {
            return this.createResinClass(name.getLocalName());
        }
        if (!uri.startsWith("urn:java:")) {
            return null;
        }
        String pkg = uri.substring("urn:java:".length());
        return TypeFactory.loadClass(pkg, name.getLocalName());
    }

    private Class<?> createResinClass(String name) {
        Class<?> cl = TypeFactory.loadClass("ee", name);
        return cl;
    }

    @Override
    public Attribute getProgramAttribute() {
        if (this._setProperty != null) {
            return this._setProperty;
        }
        return this._addProgram;
    }

    @Override
    public Attribute getContentProgramAttribute() {
        return this._addContentProgram;
    }

    @Override
    public void inject(Object bean) {
        this.introspectInject();
    }

    @Override
    public void init(Object bean) {
        this.introspectInject();
        for (int i = 0; i < this._initList.size(); ++i) {
            this._initList.get(i).inject(bean, null);
        }
    }

    @Override
    public boolean isReplace() {
        return this._replaceObject != null;
    }

    @Override
    public Object replaceObject(Object bean) {
        if (this._replaceObject != null) {
            try {
                return this._replaceObject.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw ConfigException.create(this._replaceObject, (Throwable)e);
            }
        }
        return bean;
    }

    @Override
    public Object valueOf(String text) {
        if (this._valueOf != null) {
            try {
                return this._valueOf.invoke(null, text);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._stringConstructor != null) {
            try {
                return this._stringConstructor.newInstance(text);
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        if (this._addText != null) {
            Object bean = this.create(null, TEXT);
            this._addText.setText(bean, TEXT, text);
            this.inject(bean);
            this.init(bean);
            return bean;
        }
        if (this._addProgram != null || this._addContentProgram != null) {
            Object bean = this.create(null, TEXT);
            this.inject(bean);
            try {
                PropertyStringProgram program = new PropertyStringProgram(TEXT, text);
                if (this._addProgram != null) {
                    this._addProgram.setValue(bean, TEXT, program);
                } else {
                    this._addContentProgram.setValue(bean, TEXT, program);
                }
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            this.init(bean);
            return bean;
        }
        if ("".equals(text.trim())) {
            Object bean = this.create(null, TEXT);
            this.inject(bean);
            this.init(bean);
            return bean;
        }
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._beanClass.getName(), (Object)text));
    }

    @Override
    public boolean isConstructableFromString() {
        return this._valueOf != null || this._stringConstructor != null || this._addText != null || this._addProgram != null || this._addContentProgram != null;
    }

    @Override
    public Object valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (this._beanClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value.getClass().getName().startsWith("java.lang.")) {
            return this.valueOf(String.valueOf(value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introspect() {
        Object object = _introspectLock;
        synchronized (object) {
            if (this._isIntrospecting) {
                return;
            }
            this._isIntrospecting = true;
            try {
                this.introspectParent();
                if (!this._isIntrospected) {
                    this._isIntrospected = true;
                    this._isEL = !this._beanClass.isAnnotationPresent(NonEL.class);
                    try {
                        Method[] methods = this._beanClass.getDeclaredMethods();
                        this.introspectMethods(methods);
                    }
                    catch (NoClassDefFoundError e) {
                        log.fine(this._beanClass + " " + e);
                    }
                }
                Object var4_4 = null;
                this._isIntrospecting = false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._isIntrospecting = false;
                throw throwable;
            }
        }
        this.introspectComplete();
    }

    private void introspectComplete() {
        ArrayList childList = new ArrayList(this._pendingChildList);
        for (InlineBeanType<?> child : childList) {
            super.introspectParent();
            super.introspectComplete();
        }
    }

    private boolean isIntrospecting() {
        ConfigType<T> parentType;
        if (this._isIntrospecting) {
            return true;
        }
        Class<T> parentClass = this._beanClass.getSuperclass();
        if (parentClass != null && (parentType = TypeFactory.getType(parentClass)) instanceof InlineBeanType) {
            InlineBeanType parentBean = (InlineBeanType)parentType;
            return parentBean.isIntrospecting();
        }
        return false;
    }

    private void introspectParent() {
        ConfigType<T> parentType;
        Class<T> parentClass = this._beanClass.getSuperclass();
        if (parentClass != null && (parentType = TypeFactory.getType(parentClass)) instanceof InlineBeanType) {
            InlineBeanType parentBean = (InlineBeanType)parentType;
            if (!parentBean._isIntrospected) {
                parentBean.introspect();
            }
            if (parentBean.isIntrospecting()) {
                if (!parentBean._pendingChildList.contains(this)) {
                    parentBean._pendingChildList.add(this);
                }
                return;
            }
            if (this._setParent == null) {
                this._setParent = parentBean._setParent;
            }
            if (this._replaceObject == null) {
                this._replaceObject = parentBean._replaceObject;
            }
            if (this._setConfigLocation == null) {
                this._setConfigLocation = parentBean._setConfigLocation;
            }
            if (this._setConfigUriLocation == null) {
                this._setConfigUriLocation = parentBean._setConfigUriLocation;
            }
            if (this._setConfigNode == null) {
                this._setConfigNode = parentBean._setConfigNode;
            }
            if (this._addText == null) {
                this._addText = parentBean._addText;
            }
            if (this._addProgram == null) {
                this._addProgram = parentBean._addProgram;
            }
            if (this._addContentProgram == null) {
                this._addContentProgram = parentBean._addContentProgram;
            }
            if (this._setProperty == null) {
                this._setProperty = parentBean._setProperty;
            }
            if (this._addCustomBean == null) {
                this._addCustomBean = parentBean._addCustomBean;
            }
            for (Map.Entry<QName, Attribute> entry : parentBean._nsAttributeMap.entrySet()) {
                if (this._nsAttributeMap.get(entry.getKey()) != null) continue;
                this._nsAttributeMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Attribute> entry : parentBean._attributeMap.entrySet()) {
                if (this._attributeMap.get(entry.getKey()) != null) continue;
                this._attributeMap.put((String)entry.getKey(), entry.getValue());
            }
            this._addMethodMap.putAll(parentBean._addMethodMap);
        }
    }

    public void introspectMethods(Method[] methods) {
        Constructor<?>[] constructors = this._beanClass.getConstructors();
        this._stringConstructor = InlineBeanType.findConstructor(constructors, String.class);
        HashMap<String, Method> createMap = new HashMap<String, Method>(8);
        this.fillCreateMap(createMap, methods);
        HashMap<String, Method> setterMap = new HashMap<String, Method>(8);
        this.fillSetterMap(setterMap, methods);
        for (Method method : methods) {
            ConfigType<XmlBeanConfig> customBeanType;
            Object type;
            if (method.getAnnotation(DisableConfig.class) != null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            String name = method.getName();
            if ("replaceObject".equals(name) && paramTypes.length == 0) {
                this._replaceObject = method;
                this._replaceObject.setAccessible(true);
                continue;
            }
            if ("valueOf".equals(name) && paramTypes.length == 1 && String.class.equals(paramTypes[0]) && Modifier.isStatic(method.getModifiers())) {
                this._valueOf = method;
                this._valueOf.setAccessible(true);
                continue;
            }
            if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            if ((name.equals("addBuilderProgram") || name.equals("addProgram")) && paramTypes.length == 1 && paramTypes[0].equals(ConfigProgram.class)) {
                type = TypeFactory.getType(paramTypes[0]);
                this._addProgram = new ProgramAttribute(method, (ConfigType)type);
                continue;
            }
            if (name.equals("addContentProgram") && paramTypes.length == 1 && paramTypes[0].equals(ConfigProgram.class)) {
                type = TypeFactory.getType(paramTypes[0]);
                this._addContentProgram = new ProgramAttribute(method, (ConfigType)type);
                continue;
            }
            if (name.equals("setConfigLocation") && paramTypes.length == 2 && paramTypes[0].equals(String.class) && paramTypes[1].equals(Integer.TYPE)) {
                this._setConfigLocation = method;
                continue;
            }
            if (name.equals("setConfigUriLocation") && paramTypes.length == 2 && paramTypes[0].equals(String.class) && paramTypes[1].equals(Integer.TYPE)) {
                this._setConfigUriLocation = method;
                continue;
            }
            if (name.equals("setConfigNode") && paramTypes.length == 1 && paramTypes[0].equals(Node.class)) {
                this._setConfigNode = method;
                continue;
            }
            if (name.equals("addCustomBean") && paramTypes.length == 1 && paramTypes[0].equals(XmlBeanConfig.class)) {
                customBeanType = TypeFactory.getType(XmlBeanConfig.class);
                this._addCustomBean = new XmlBeanAttribute(method, customBeanType);
                continue;
            }
            if (name.equals("addAnnotation") && paramTypes.length == 1 && paramTypes[0].equals(Annotation.class)) {
                customBeanType = TypeFactory.getType(XmlBeanConfig.class);
                this._addCustomBean = new XmlBeanAttribute(method, customBeanType);
                continue;
            }
            if (name.equals("setProperty") && paramTypes.length == 2 && paramTypes[0].equals(String.class)) {
                type = TypeFactory.getType(paramTypes[1]);
                PropertyAttribute attr = new PropertyAttribute(method, (ConfigType<?>)type);
                this._setProperty = attr;
                continue;
            }
            if (name.equals("setParent") && paramTypes.length == 1) {
                this._setParent = method;
                continue;
            }
            if (name.equals("add") && paramTypes.length == 1) {
                type = TypeFactory.getType(paramTypes[0]);
                AddAttribute addAttr = new AddAttribute(method, (ConfigType<?>)type);
                this._addMethodMap.put(paramTypes[0], addAttr);
                if (!paramTypes[0].equals(Bean.class)) continue;
                this._addBean = addAttr;
                continue;
            }
            if ((name.startsWith("set") || name.startsWith("add")) && paramTypes.length == 1 && createMap.get(name.substring(3)) == null) {
                String className = name.substring(3);
                String xmlName = this.toXmlName(name.substring(3));
                TagName tagName = method.getAnnotation(TagName.class);
                if (tagName != null) {
                    for (String propName : tagName.value()) {
                        this.addProp(propName, method);
                    }
                } else {
                    this.addProp(xmlName, method);
                }
                this.addProp(this.toCamelName(className), method);
                continue;
            }
            if (!name.startsWith("create") || paramTypes.length != 0 || Void.TYPE.equals(method.getReturnType())) continue;
            type = method.getReturnType();
            Method setter = setterMap.get(name.substring(6));
            CreateAttribute attr = new CreateAttribute(method, type, setter);
            String xmlName = this.toXmlName(name.substring(6));
            TagName tagName = method.getAnnotation(TagName.class);
            if (tagName != null) {
                for (String propName : tagName.value()) {
                    this.addProp(propName, attr);
                }
                continue;
            }
            this.addProp(xmlName, attr);
        }
    }

    private void addProp(String propName, Method method) {
        Attribute attr;
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> type = paramTypes[0];
        if (propName.equals("text") && (type.equals(String.class) || type.equals(RawString.class))) {
            this._addText = attr = new TextAttribute(method, type);
            this._attributeMap.put("#text", attr);
        } else {
            attr = new SetterAttribute(method, type);
        }
        this.addProp(propName, attr);
    }

    private void addProp(String propName, Attribute attr) {
        Attribute oldAttr = this._attributeMap.get(propName);
        if (oldAttr == null) {
            this._attributeMap.put(propName, attr);
        } else if (!(attr.equals(oldAttr) || oldAttr.isConfigurable() && !attr.isConfigurable())) {
            if (attr.isConfigurable() && !oldAttr.isConfigurable()) {
                this._attributeMap.put(propName, attr);
            } else if (!attr.isAssignableFrom(oldAttr)) {
                if (oldAttr.isAssignableFrom(attr)) {
                    this._attributeMap.put(propName, attr);
                } else {
                    log.fine(L.l("{0}: conflicting attribute for '{1}' between {2} and {3}", (Object)this, (Object)propName, (Object)attr, (Object)oldAttr));
                }
            }
        }
        if (propName.equals("value")) {
            this._attributeMap.put("#text", attr);
            if (this._addText == null) {
                this._addText = attr;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectInject() {
        Object object = _introspectLock;
        synchronized (object) {
            if (this._initList != null) {
                return;
            }
            ArrayList<ConfigProgram> initList = new ArrayList<ConfigProgram>();
            InjectionTargetBuilder.introspectInit(initList, this.getAnnotatedType());
            this._initList = initList;
        }
    }

    private static Constructor findConstructor(Constructor<?>[] constructors, Class<?> ... types) {
        for (Constructor<?> ctor : constructors) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (!InlineBeanType.isMatch(paramTypes, types)) continue;
            return ctor;
        }
        return null;
    }

    private static boolean isMatch(Class<?>[] aTypes, Class<?>[] bTypes) {
        if (aTypes.length != bTypes.length) {
            return false;
        }
        for (int i = aTypes.length - 1; i >= 0; --i) {
            if (aTypes[i].equals(bTypes[i])) continue;
            return false;
        }
        return true;
    }

    private void fillCreateMap(HashMap<String, Method> createMap, Method[] methods) {
        for (Method method : methods) {
            String name = method.getName();
            if (!name.startsWith("create") || name.equals("create") || method.getParameterTypes().length != 0) continue;
            createMap.put(name.substring("create".length()), method);
        }
    }

    private void fillSetterMap(HashMap<String, Method> setterMap, Method[] methods) {
        for (Method method : methods) {
            String name = method.getName();
            if (name.length() <= 3 || !name.startsWith("add") && !name.startsWith("set") || method.getParameterTypes().length != 1) continue;
            setterMap.put(name.substring("set".length()), method);
        }
    }

    private String toXmlName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch) && i > 0 && (Character.isLowerCase(name.charAt(i - 1)) || i + 1 < name.length() && Character.isLowerCase(name.charAt(i + 1)))) {
                sb.append('-');
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    private String toCamelName(String name) {
        return Introspector.decapitalize(name);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanClass.getName() + "]";
    }
}

