/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqExpr
extends AbstractBooleanExpr {
    private final Expr _left;
    private final Expr _right;

    public EqExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    @Override
    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    @Override
    public boolean evalBoolean(ELContext env) throws ELException {
        Class<?> bType;
        Object bObj;
        Object aObj = this._left.getValue(env);
        if (aObj == (bObj = this._right.getValue(env))) {
            return true;
        }
        if (aObj == null || bObj == null) {
            return false;
        }
        Class<?> aType = aObj.getClass();
        if (aType.equals(bType = bObj.getClass())) {
            return aObj.equals(bObj);
        }
        if (aType == Boolean.class || bType == Boolean.class) {
            boolean b;
            boolean a = EqExpr.toBoolean(aObj, env);
            return a == (b = EqExpr.toBoolean(bObj, env));
        }
        try {
            if (aObj instanceof BigDecimal || bObj instanceof BigDecimal) {
                BigDecimal a = EqExpr.toBigDecimal(aObj, env);
                BigDecimal b = EqExpr.toBigDecimal(bObj, env);
                return a.equals(b);
            }
            if (aType == Double.class || aType == Float.class || bType == Double.class || bType == Float.class) {
                double b;
                double a = EqExpr.toDouble(aObj, env);
                return a == (b = EqExpr.toDouble(bObj, env));
            }
            if (aType == BigInteger.class || bType == BigInteger.class) {
                BigInteger a = EqExpr.toBigInteger(aObj, env);
                BigInteger b = EqExpr.toBigInteger(bObj, env);
                return a.equals(b);
            }
            if (aObj instanceof Number || bObj instanceof Number) {
                long b;
                long a = EqExpr.toLong(aObj, env);
                return a == (b = EqExpr.toLong(bObj, env));
            }
        }
        catch (ELException e) {
            log.finest(L.l("`{0}' in `{1}'", (Object)e.getMessage(), (Object)this.toString()));
            return false;
        }
        if (aObj instanceof Enum && bObj instanceof String) {
            Enum aEnum = (Enum)aObj;
            Enum<?> bEnum = this.toEnum((String)bObj, aEnum);
            return aEnum.equals(bEnum);
        }
        if (bObj instanceof Enum && aObj instanceof String) {
            Enum bEnum = (Enum)bObj;
            Enum<?> aEnum = this.toEnum((String)aObj, bEnum);
            return bEnum.equals(aEnum);
        }
        if (aObj instanceof String || bObj instanceof String) {
            String a = EqExpr.toString(aObj, env);
            String b = EqExpr.toString(bObj, env);
            return a.equals(b);
        }
        return aObj.equals(bObj);
    }

    private Enum<?> toEnum(String v, Enum<?> e) {
        if (v == null || v.isEmpty()) {
            return null;
        }
        return Enum.valueOf(e.getClass(), v);
    }

    @Override
    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.EqExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EqExpr)) {
            return false;
        }
        EqExpr expr = (EqExpr)((Object)o);
        return this._left.equals((Object)expr._left) && this._right.equals((Object)expr._right);
    }

    @Override
    public String toString() {
        return "(" + (Object)((Object)this._left) + " eq " + (Object)((Object)this._right) + ")";
    }
}

