/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELParseException;
import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StaticMethodExpr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;

public class FunctionExpr
extends Expr {
    private Expr _expr;
    private Expr[] _args;

    public FunctionExpr(Expr expr, Expr[] args) {
        this._expr = expr;
        this._args = args;
    }

    public Object getValue(ELContext env) throws ELException {
        if (this._expr instanceof StaticMethodExpr) {
            return ((StaticMethodExpr)this._expr).evalMethod(this._args, env);
        }
        Object aObj = this._expr.getValue(env);
        Method method = null;
        if (aObj instanceof Method) {
            method = (Method)aObj;
        } else if (aObj instanceof Method[]) {
            Method[] methods = (Method[])aObj;
            if (methods.length < this._args.length) {
                return null;
            }
            method = methods[this._args.length];
        }
        if (method == null) {
            throw new ELParseException(L.l("'{0}' is an unknown function.", (Object)this._expr));
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != this._args.length) {
            throw new ELParseException(L.l("arguments '{0}' do not match expected length {1}.", (Object)this._expr, params.length));
        }
        try {
            Object[] objs = new Object[this._args.length];
            for (int i = 0; i < params.length; ++i) {
                objs[i] = MethodExpr.evalArg(params[i], this._args[i], env);
            }
            return method.invoke(null, objs);
        }
        catch (ELException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.FunctionExpr(");
        this._expr.printCreate(os);
        os.print(", new com.caucho.el.Expr[] {");
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this._args[i].printCreate(os);
        }
        os.println("})");
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunctionExpr)) {
            return false;
        }
        FunctionExpr expr = (FunctionExpr)((Object)o);
        if (!this._expr.equals((Object)expr._expr)) {
            return false;
        }
        if (this._args.length != expr._args.length) {
            return false;
        }
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i].equals((Object)expr._args[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._expr);
        sb.append('(');
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append((Object)this._args[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

