/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractValueExpression;
import com.caucho.el.Expr;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringValueExpression
extends AbstractValueExpression {
    protected static final Logger log = Logger.getLogger(StringValueExpression.class.getName());
    protected static final L10N L = new L10N(StringValueExpression.class);
    private Class _expectedType;

    public StringValueExpression(Expr expr, String expressionString, Class expectedType) {
        super(expr, expressionString);
        this._expectedType = expectedType;
    }

    public StringValueExpression(Expr expr, String expressionString) {
        super(expr, expressionString);
    }

    public StringValueExpression(Expr expr) {
        super(expr);
    }

    private StringValueExpression() {
    }

    @Override
    public Class<?> getExpectedType() {
        if (this._expectedType != null) {
            return this._expectedType;
        }
        return this._expr.getExpectedType();
    }

    @Override
    public Class<?> getType(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        if (this._expr.isConstant()) {
            return String.class;
        }
        Class<?> type = this._expr.getType(context);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._expr.getExpressionString(), (Object)context));
        }
        return String.class;
    }

    @Override
    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException("context can't be null");
        }
        String result = this._expr.evalString(context);
        if (!context.isPropertyResolved() && (result == null || "".equals(result))) {
            throw new PropertyNotFoundException(L.l("'{0}' not found in context '{1}'.", (Object)this._expr.getExpressionString(), (Object)context));
        }
        return result;
    }

    public ValueReference getValueReference(ELContext context) {
        return this._expr.getValueReference(context);
    }
}

