/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.env.health.HealthSystemFacade;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread1.AbstractThreadLauncher1;
import com.caucho.env.thread1.ResinThread1;
import com.caucho.env.thread1.ThreadPool1;
import com.caucho.inject.Module;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

@Module
class ThreadLauncher1
extends AbstractThreadLauncher1 {
    private static final Logger log = Logger.getLogger(ThreadLauncher1.class.getName());
    public static final String THREAD_FULL_EVENT = "caucho.thread.pool.full";
    public static final String THREAD_CREATE_THROTTLE_EVENT = "caucho.thread.pool.throttle";
    private static final int DEFAULT_PRIORITY_IDLE_MIN = 2;
    private final ThreadPool1 _pool;
    private int _priorityIdleMin;
    private final AtomicInteger _priorityIdleCount = new AtomicInteger();

    ThreadLauncher1(ThreadPool1 pool) {
        super(ClassLoader.getSystemClassLoader());
        this._pool = pool;
        this.setPriorityIdleMin(2);
    }

    public void setPriorityIdleMin(int min) {
        if (min <= 0) {
            throw new IllegalArgumentException();
        }
        this._priorityIdleMin = min;
        this.update();
    }

    public int getPriorityIdleMin() {
        return this._priorityIdleMin;
    }

    protected boolean beginPriorityIdle() {
        int priorityIdle = this._priorityIdleCount.get();
        return priorityIdle < this._priorityIdleMin && this._priorityIdleCount.compareAndSet(priorityIdle, priorityIdle + 1);
    }

    protected void onPriorityIdleEnd() {
        int priorityIdleCount = this._priorityIdleCount.getAndDecrement();
        if (priorityIdleCount < this._priorityIdleMin) {
            this.wake();
        }
    }

    protected boolean isIdleTooLow(int startingCount) {
        int surplus = this._priorityIdleCount.get() - this._priorityIdleMin;
        if (surplus >= 0) {
            return super.isIdleTooLow(startingCount);
        }
        if ((startingCount += surplus) < 0) {
            return true;
        }
        return super.isIdleTooLow(startingCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startWorkerThread() {
        boolean isValid = false;
        try {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("resin-thread-launcher");
            thread.start();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (isValid) throw throwable;
            ShutdownSystem.shutdownActive(ExitCode.THREAD, "Cannot create ThreadPool thread.");
            throw throwable;
        }
    }

    protected long getCurrentTimeActual() {
        return System.currentTimeMillis();
    }

    protected void launchChildThread(int id) {
        try {
            ResinThread1 poolThread = new ResinThread1(id, this._pool, this);
            poolThread.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
            String msg = "Resin exiting because of failed thread";
            ShutdownSystem.shutdownActive(ExitCode.THREAD, msg);
        }
    }

    protected void onThreadMax() {
        HealthSystemFacade.fireEvent(THREAD_FULL_EVENT, "threads=" + this.getThreadCount());
    }

    protected void onThrottle(String msg) {
        log.warning(msg);
        HealthSystemFacade.fireEvent(THREAD_CREATE_THROTTLE_EVENT, msg);
    }

    public int getPriorityIdleCount() {
        return this._priorityIdleCount.get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._pool + "]";
    }
}

