/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.util.CharBuffer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineMap
implements Serializable {
    private String _dstFilename;
    private String _srcFilename;
    private String _srcType = "JSP";
    private String _lastSrcFilename;
    private ArrayList<Line> _lines = new ArrayList();

    public LineMap() {
    }

    public LineMap(String dstFilename, String srcFilename) {
        int tail = dstFilename.lastIndexOf(47);
        if (tail < 0) {
            this._dstFilename = dstFilename;
        } else {
            dstFilename = dstFilename.substring(tail + 1);
        }
        this._lastSrcFilename = this._srcFilename = srcFilename;
    }

    public LineMap(String dstFilename) {
        int tail = dstFilename.lastIndexOf(47);
        this._dstFilename = tail < 0 ? dstFilename : dstFilename.substring(tail + 1);
    }

    public void setSourceType(String type) {
        this._srcType = type;
    }

    public String getSourceType() {
        return this._srcType;
    }

    public String getDestFilename() {
        return this._dstFilename;
    }

    public String getLastSourceFilename() {
        return this._lastSrcFilename;
    }

    public boolean add(String srcFilename, int srcLine, int dstLine) {
        return this.add(srcFilename, srcLine, dstLine, false);
    }

    public boolean add(String srcFilename, int srcLine, int dstLine, boolean isPreferLast) {
        this._lastSrcFilename = srcFilename;
        if (this._lines.size() > 0) {
            Line line = this._lines.get(this._lines.size() - 1);
            if (line.add(srcFilename, srcLine, dstLine, isPreferLast)) {
                Line prevLine;
                if (this._lines.size() > 1 && (prevLine = this._lines.get(this._lines.size() - 2)).merge(line)) {
                    this._lines.remove(this._lines.size() - 1);
                }
                return true;
            }
            if (line.getLastDestinationLine() + 1 < dstLine) {
                this._lines.add(new Line(line.getLastSourceLine(), line.getSourceFilename(), 1, line.getLastDestinationLine() + 1, dstLine - line.getLastDestinationLine()));
            }
        }
        this._lines.add(new Line(srcFilename, srcLine, dstLine));
        return true;
    }

    public void addLine(int startLine, String sourceFile, int repeatCount, int outputLine, int outputIncrement) {
        this._lines.add(new Line(startLine, sourceFile, repeatCount, outputLine, outputIncrement));
    }

    public void add(int srcLine, int dstLine) {
        this.add(this._lastSrcFilename, srcLine, dstLine);
    }

    public Iterator<Line> iterator() {
        return this._lines.iterator();
    }

    public int size() {
        return this._lines.size();
    }

    public Line get(int i) {
        return this._lines.get(i);
    }

    public Line getLine(int line) {
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (map._dstLine > line || line > map.getLastDestinationLine()) continue;
            return map;
        }
        return null;
    }

    public String convertError(String filename, int line, int column, String message) {
        String srcFilename = null;
        boolean destLine = false;
        int srcLine = 0;
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (filename != null && !filename.endsWith(this._dstFilename) || map._dstLine > line || line > map.getLastDestinationLine()) continue;
            srcFilename = map._srcFilename;
            srcLine = map.getSourceLine(line);
        }
        if (srcFilename != null) {
            return srcFilename + ":" + srcLine + ": " + message;
        }
        return filename + ":" + line + ": " + message;
    }

    public String convertLine(String filename, int line) {
        Line bestLine = this.getLine(line);
        if (bestLine != null) {
            return bestLine.getSourceFilename() + ":" + bestLine.getSourceLine(line);
        }
        return filename + ":" + line;
    }

    public void printStackTrace(Throwable e, OutputStream os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            byte[] b = cb.toString().getBytes();
            try {
                os.write(b, 0, b.length);
            }
            catch (IOException iOException) {}
        } else {
            System.out.println(cb);
        }
    }

    public void printStackTrace(Throwable e, PrintWriter os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = this.filter(array);
        if (os != null) {
            os.print(cb.toString());
        } else {
            System.out.println(cb);
        }
    }

    private CharBuffer filter(char[] array) {
        CharBuffer buf = new CharBuffer();
        CharBuffer fun = new CharBuffer();
        CharBuffer file = new CharBuffer();
        int i = 0;
        while (i < array.length) {
            int end;
            fun.clear();
            file.clear();
            int start = i;
            for (end = i; end < array.length && array[end] != '\n'; ++end) {
            }
            while (i < end && Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            if (!fun.endsWith("at")) {
                for (i = start; i < end; ++i) {
                    buf.append(array[i]);
                }
                i = end + 1;
                buf.append('\n');
                continue;
            }
            while (i < end && Character.isWhitespace(array[i])) {
                ++i;
            }
            fun.clear();
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != '(') {
                fun.append(array[i]);
                ++i;
            }
            if (i < end && array[i] == '(') {
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            int line = -1;
            if (i < end && array[i] == ':') {
                line = 0;
                ++i;
                while (i < end && array[i] >= '0' && array[i] <= '9') {
                    line = 10 * line + array[i] - 48;
                    ++i;
                }
            }
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != ':' && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            buf.append("\tat ");
            buf.append(fun);
            buf.append("(");
            String dstFile = file.toString();
            if (dstFile.equals(this._dstFilename)) {
                this.convertError(buf, line);
            } else {
                buf.append(file);
                if (line > 0) {
                    buf.append(":");
                    buf.append(line);
                }
            }
            buf.append(array, i, end - i);
            buf.append('\n');
            i = end + 1;
        }
        return buf;
    }

    private void convertError(CharBuffer buf, int line) {
        String srcFilename = null;
        int destLine = 0;
        int srcLine = 0;
        int srcTailLine = Integer.MAX_VALUE;
        for (int i = 0; i < this._lines.size(); ++i) {
            Line map = this._lines.get(i);
            if (map._dstLine > line || line > map.getLastDestinationLine()) continue;
            srcFilename = map._srcFilename;
            destLine = map._dstLine;
            srcLine = map.getSourceLine(line);
            break;
        }
        if (srcFilename == null) {
            srcFilename = this._lines.size() > 0 ? this._lines.get((int)0)._srcFilename : "";
        }
        buf.append(srcFilename);
        if (line >= 0) {
            buf.append(":");
            buf.append(srcLine + (line - destLine));
        }
    }

    public static class Line
    implements Serializable {
        String _srcFilename;
        int _srcLine;
        int _dstLine;
        int _dstIncrement = 1;
        int _repeat = 1;

        public Line() {
        }

        Line(String srcFilename, int srcLine, int dstLine) {
            this._srcFilename = srcFilename;
            this._srcLine = srcLine;
            this._dstLine = dstLine;
        }

        Line(int srcLine, String srcFilename, int repeat, int dstLine, int dstIncrement) {
            this._srcFilename = srcFilename;
            this._srcLine = srcLine;
            this._dstLine = dstLine;
            this._repeat = repeat;
            this._dstIncrement = dstIncrement;
        }

        boolean add(String srcFilename, int srcLine, int dstLine, boolean isPreferLast) {
            if (!(this._srcFilename == null || this._srcFilename.equals(srcFilename) && srcFilename != null)) {
                return false;
            }
            if (dstLine <= this._dstLine) {
                if (!isPreferLast) {
                    return true;
                }
                if (this._dstIncrement == 1 && this._repeat == 1) {
                    this._srcLine = srcLine;
                    return true;
                }
                if (this._repeat > 1) {
                    --this._repeat;
                    return false;
                }
                if (this._dstIncrement > 1) {
                    --this._dstIncrement;
                    return false;
                }
                return true;
            }
            if (srcLine == this._srcLine) {
                this._dstIncrement = dstLine - this._dstLine + 1;
                return true;
            }
            if (dstLine - this._dstLine == (srcLine - this._srcLine) * this._dstIncrement) {
                this._repeat = srcLine - this._srcLine + 1;
                return true;
            }
            if (srcLine == this._srcLine + 1 && this._repeat == 1) {
                this._dstIncrement = dstLine - this._dstLine;
                return false;
            }
            return false;
        }

        boolean merge(Line next) {
            if (this._srcFilename != null && !this._srcFilename.equals(next._srcFilename)) {
                return false;
            }
            if (this._dstIncrement != next._dstIncrement) {
                return false;
            }
            if (this.getLastDestinationLine() + 1 != next._dstLine) {
                return false;
            }
            if (this.getLastSourceLine() + 1 != next._srcLine) {
                return false;
            }
            this._repeat += next._repeat;
            return true;
        }

        public String getSourceFilename() {
            return this._srcFilename;
        }

        public int getSourceLine() {
            return this._srcLine;
        }

        public int getSourceLine(int dstLine) {
            return this._srcLine + (dstLine - this._dstLine) / this._dstIncrement;
        }

        public int getRepeatCount() {
            return this._repeat;
        }

        public int getDestinationLine() {
            return this._dstLine;
        }

        public int getLastSourceLine() {
            return this._srcLine + this._repeat - 1;
        }

        public int getLastDestinationLine() {
            return this._dstLine + this._dstIncrement * this._repeat - 1;
        }

        public int getDestinationIncrement() {
            return this._dstIncrement;
        }

        public String toString() {
            return "Line[src:" + this._srcFilename + ":" + this._srcLine + ",dst:" + this._dstLine + "]";
        }
    }
}

