/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.java.LineMap;
import com.caucho.java.WorkDir;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptStackTrace {
    private static final L10N L = new L10N(ScriptStackTrace.class);
    private static final Logger log = Log.open(ScriptStackTrace.class);
    private static WeakHashMap<Class, LineMap> _scriptMap = new WeakHashMap();

    public static void printStackTrace(Throwable e, PrintWriter out) {
        StackTraceElement lastHead = null;
        DynamicClassLoader loader = SimpleLoader.create(WorkDir.getLocalWorkDir());
        while (true) {
            if (e.getMessage() != null) {
                out.println(e.getClass().getName() + ": " + e.getMessage());
            } else {
                out.println(e.getClass().getName());
            }
            StackTraceElement[] trace = e.getStackTrace();
            StackTraceElement nextHead = trace.length > 0 ? trace[0] : null;
            for (int i = 0; i < trace.length && !trace[i].equals(lastHead); ++i) {
                out.print("\tat ");
                ScriptStackTrace.printStackTraceElement(trace[i], out, loader);
            }
            lastHead = nextHead;
            Throwable cause = e.getCause();
            if (cause == null) break;
            out.print("Caused by: ");
            e = cause;
        }
    }

    private static void printStackTraceElement(StackTraceElement trace, PrintWriter out, ClassLoader loader) {
        try {
            LineMap.Line line;
            LineMap map = ScriptStackTrace.getScriptLineMap(trace.getClassName(), loader);
            if (map != null && (line = map.getLine(trace.getLineNumber())) != null) {
                out.print(trace.getClassName() + "." + trace.getMethodName());
                out.print("(" + line.getSourceFilename() + ":");
                out.println(line.getSourceLine(trace.getLineNumber()) + ")");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out.println(trace);
    }

    public static LineMap getScriptLineMap(String className, ClassLoader loader) {
        try {
            Class<?> cl = loader.loadClass(className);
            LineMap map = _scriptMap.get(cl);
            if (map == null) {
                map = ScriptStackTrace.loadScriptMap(cl);
                _scriptMap.put(cl, map);
            }
            return map;
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LineMap loadScriptMap(Class cl) {
        ClassLoader loader = cl.getClassLoader();
        if (loader == null) {
            return new LineMap();
        }
        try {
            LineMap lineMap;
            InputStream is;
            block15: {
                LineMap className2;
                block14: {
                    LineMap lineMap2;
                    block13: {
                        String pathName = cl.getName().replace('.', '/') + ".class";
                        is = loader.getResourceAsStream(pathName);
                        if (is == null) {
                            return null;
                        }
                        try {
                            JavaClass jClass = new ByteCodeParser().parse(is);
                            Attribute attr = jClass.getAttribute("SourceDebugExtension");
                            if (attr == null) {
                                int p = cl.getName().indexOf(36);
                                if (p > 0) {
                                    String className2 = cl.getName().substring(0, p);
                                    lineMap2 = ScriptStackTrace.loadScriptMap(loader.loadClass(className2));
                                    Object var13_14 = null;
                                    if (is == null) return lineMap2;
                                    break block13;
                                }
                                className2 = new LineMap();
                                break block14;
                            }
                            if (!(attr instanceof OpaqueAttribute)) {
                                throw new IllegalStateException(L.l("Expected opaque attribute at '{0}'", (Object)attr));
                            }
                            byte[] value = ((OpaqueAttribute)attr).getValue();
                            ByteArrayInputStream bis = new ByteArrayInputStream(value);
                            ReadStream rs = Vfs.openRead(bis);
                            rs.setEncoding("UTF-8");
                            try {
                                lineMap = ScriptStackTrace.parseSmap(rs);
                                Object var11_19 = null;
                                rs.close();
                                break block15;
                            }
                            catch (Throwable throwable) {
                                Object var11_20 = null;
                                rs.close();
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                    }
                    is.close();
                    return lineMap2;
                }
                Object var13_15 = null;
                if (is == null) return className2;
                is.close();
                return className2;
            }
            Object var13_16 = null;
            if (is == null) return lineMap;
            is.close();
            return lineMap;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return new LineMap();
        }
    }

    private static LineMap parseSmap(ReadStream is) throws IOException {
        int ch;
        String defaultStratum;
        String smap = is.readln();
        if (!smap.equals("SMAP")) {
            throw new IOException(L.l("Illegal header"));
        }
        String outputFile = is.readln().trim();
        String stratum = defaultStratum = is.readln().trim();
        HashMap<String, String> fileMap = new HashMap<String, String>();
        LineMap lineMap = new LineMap(outputFile);
        block6: while ((ch = is.read()) >= 0) {
            if (ch != 42) {
                throw new IOException(L.l("unexpected character '{0}'", (Object)String.valueOf((char)ch)));
            }
            int code = is.read();
            String value = is.readln();
            switch (code) {
                case 69: {
                    break block6;
                }
                case 83: {
                    stratum = value.trim();
                    continue block6;
                }
                case 70: {
                    while ((ch = is.read()) > 0 && ch != 42) {
                        String first;
                        if (ch == 43) {
                            first = is.readln().trim();
                            String second = is.readln().trim();
                            int p = first.indexOf(32);
                            String key = first.substring(0, p);
                            String file = first.substring(p + 1).trim();
                            if (fileMap.size() == 0) {
                                fileMap.put("", second);
                            }
                            fileMap.put(key, second);
                            continue;
                        }
                        first = is.readln().trim();
                        int p = first.indexOf(32);
                        String key = first.substring(0, p);
                        String file = first.substring(p + 1).trim();
                        if (fileMap.size() == 0) {
                            fileMap.put("", file);
                        }
                        fileMap.put(key, file);
                    }
                    if (ch != 42) continue block6;
                    is.unread();
                    continue block6;
                }
                case 76: {
                    while ((ch = is.read()) != 42 && ch > 0) {
                        is.unread();
                        String line = is.readln().trim();
                        ScriptStackTrace.addMap(line, fileMap, lineMap);
                    }
                    if (ch != 42) continue block6;
                    is.unread();
                    continue block6;
                }
                default: {
                    while ((ch = is.read()) != 42) {
                        is.readln();
                    }
                    if (ch != 42) continue block6;
                    is.unread();
                    continue block6;
                }
            }
        }
        return lineMap;
    }

    private static void addMap(String line, HashMap<String, String> fileMap, LineMap lineMap) {
        int colon = line.indexOf(58);
        if (colon < 0) {
            return;
        }
        int hash = line.indexOf(35);
        int startLine = 0;
        String fileId = "";
        int repeatCount = 1;
        if (hash < 0) {
            startLine = Integer.parseInt(line.substring(0, colon));
        } else {
            startLine = Integer.parseInt(line.substring(0, hash));
            int comma = line.indexOf(44, hash);
            if (comma > 0 && comma < colon) {
                fileId = line.substring(hash + 1, comma).trim();
                repeatCount = Integer.parseInt(line.substring(comma + 1, colon));
            } else {
                fileId = line.substring(hash + 1, colon).trim();
            }
        }
        int outputLine = -1;
        int outputIncrement = 1;
        int comma = line.indexOf(44, colon);
        if (comma > 0) {
            outputLine = Integer.parseInt(line.substring(colon + 1, comma));
            outputIncrement = Integer.parseInt(line.substring(comma + 1));
        } else {
            outputLine = Integer.parseInt(line.substring(colon + 1));
        }
        String file = fileMap.get(fileId);
        lineMap.addLine(startLine, file, repeatCount, outputLine, outputIncrement);
    }
}

