/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.inject.Module;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.RequireReload;
import com.caucho.make.DependencyContainer;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.JniTroubleshoot;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.CodeSource;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class ClassEntry
implements Dependency {
    private static final L10N L = new L10N(ClassEntry.class);
    private static final Logger log = Logger.getLogger(ClassEntry.class.getName());
    private static boolean _hasJNIReload;
    private static boolean _hasAnnotations;
    private static final JniTroubleshoot _jniTroubleshoot;
    private DynamicClassLoader _loader;
    private String _name;
    private Path _classPath;
    private PersistentDependency _depend;
    private boolean _classIsModified;
    private Path _sourcePath;
    private long _sourceLastModified;
    private long _sourceLength;
    private ClassPackage _classPackage;
    private CodeSource _codeSource;
    private WeakReference<Class<?>> _clRef;

    public ClassEntry(DynamicClassLoader loader, String name, Path sourcePath, Path classPath, CodeSource codeSource) {
        this._loader = loader;
        this._name = name;
        this._classPath = classPath;
        this.setDependPath(classPath);
        if (sourcePath != null && !sourcePath.equals(classPath)) {
            this._sourcePath = sourcePath;
            this._sourceLastModified = sourcePath.getLastModified();
            this._sourceLength = sourcePath.getLength();
        }
        this._codeSource = codeSource;
    }

    public String getName() {
        return this._name;
    }

    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public CodeSource getCodeSource() {
        return this._codeSource;
    }

    public Path getSourcePath() {
        return this._sourcePath;
    }

    protected void setDependPath(Path dependPath) {
        this._depend = dependPath instanceof JarPath ? ((JarPath)dependPath).getDepend() : new Depend(dependPath);
    }

    protected boolean addDependencies(DependencyContainer container) {
        if (this._classPath instanceof JarPath) {
            container.add(this._depend);
            return false;
        }
        if (_hasJNIReload) {
            container.add(this);
            return true;
        }
        if (this._sourcePath == null) {
            container.add(this._depend);
            return false;
        }
        container.add(this);
        return true;
    }

    public void setSourceLength(long length) {
        this._sourceLength = length;
    }

    public void setSourceLastModified(long lastModified) {
        this._sourceLastModified = lastModified;
    }

    public ClassPackage getClassPackage() {
        return this._classPackage;
    }

    public void setClassPackage(ClassPackage pkg) {
        this._classPackage = pkg;
    }

    @Override
    public boolean isModified() {
        if (this._depend.isModified()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("class modified: " + this._depend);
            }
            return this.reloadIsModified();
        }
        if (this._sourcePath == null) {
            return false;
        }
        if (this._sourcePath.getLastModified() != this._sourceLastModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("source modified time: " + this._sourcePath + " old:" + QDate.formatLocal(this._sourceLastModified) + " new:" + QDate.formatLocal(this._sourcePath.getLastModified()));
            }
            if (!this.compileIsModified()) {
                return false;
            }
            boolean isModified = this.reloadIsModified();
            return isModified;
        }
        if (this._sourcePath.getLength() != this._sourceLength) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("source modified length: " + this._sourcePath + " old:" + this._sourceLength + " new:" + this._sourcePath.getLength());
            }
            if (!this.compileIsModified()) {
                return false;
            }
            return this.reloadIsModified();
        }
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._depend.logModified(log)) {
            return true;
        }
        if (this._sourcePath == null) {
            return false;
        }
        if (this._sourcePath.getLastModified() != this._sourceLastModified) {
            log.info("source modified time: " + this._sourcePath + " old:" + QDate.formatLocal(this._sourceLastModified) + " new:" + QDate.formatLocal(this._sourcePath.getLastModified()));
            return true;
        }
        if (this._sourcePath.getLength() != this._sourceLength) {
            log.info("source modified length: " + this._sourcePath + " old:" + this._sourceLength + " new:" + this._sourcePath.getLength());
            return true;
        }
        return false;
    }

    public boolean compileIsModified() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadIsModified() {
        if (this._classIsModified) {
            return true;
        }
        if (!_hasJNIReload || !this._classPath.canRead()) {
            return true;
        }
        try {
            Class cl;
            long length = this._classPath.getLength();
            Class clazz = cl = this._clRef != null ? (Class)this._clRef.get() : null;
            if (cl == null) {
                return false;
            }
            if (cl.isAnnotationPresent(RequireReload.class)) {
                return true;
            }
            ReadStream is = this._classPath.openRead();
            byte[] bytecode = new byte[(int)length];
            try {
                is.readAll(bytecode, 0, bytecode.length);
                Object var7_6 = null;
                is.close();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                is.close();
                throw throwable;
            }
            int result = ClassEntry.reloadNative(cl, bytecode, 0, bytecode.length);
            if (result != 0) {
                this._classIsModified = true;
                return true;
            }
            this.setDependPath(this._classPath);
            if (this._sourcePath != null) {
                this._sourceLastModified = this._sourcePath.getLastModified();
                this._sourceLength = this._sourcePath.getLength();
            }
            log.info("Reloading " + cl.getName());
            return false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            this._classIsModified = true;
            return true;
        }
    }

    public Path getClassPath() {
        return this._classPath;
    }

    public Class<?> getEntryClass() {
        return this._clRef != null ? (Class)this._clRef.get() : null;
    }

    public void setEntryClass(Class<?> cl) {
        this._clRef = new WeakReference(cl);
    }

    public void preLoad() throws ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ByteBuffer buffer) throws IOException {
        ClassEntry classEntry = this;
        synchronized (classEntry) {
            Path classPath = this.getClassPath();
            buffer.clear();
            int retry = 3;
            for (int i = 0; i < retry; ++i) {
                Object var13_10;
                long length = -1L;
                ReadStream is = classPath.openRead();
                try {
                    length = classPath.getLength();
                    long lastModified = classPath.getLastModified();
                    if (length < 0L) {
                        throw new IOException("class loading failed because class file '" + classPath + "' does not have a positive length.  Possibly the file has been overwritten");
                    }
                    buffer.setLength((int)length);
                    int results = is.readAll(buffer.getBuffer(), 0, (int)length);
                    if ((long)results == length && length == classPath.getLength() && lastModified == classPath.getLastModified()) {
                        var13_10 = null;
                        is.close();
                        return;
                    }
                    log.warning(L.l("{0}: class file length mismatch expected={1} received={2}.  The class file may have been modified concurrently.", (Object)this, (Object)length, (Object)results));
                }
                catch (Throwable throwable) {
                    var13_10 = null;
                    is.close();
                    throw throwable;
                }
                var13_10 = null;
                is.close();
            }
        }
    }

    public boolean postLoad() {
        return false;
    }

    public static boolean isReloadEnabled() {
        return _hasJNIReload;
    }

    public String toString() {
        if (this._sourcePath == null) {
            return this.getClass().getSimpleName() + "[" + this._classPath + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._classPath + ", src=" + this._sourcePath + "]";
    }

    public static native boolean canReloadNative();

    public static native int reloadNative(Class<?> var0, byte[] var1, int var2, int var3);

    static {
        JniTroubleshoot jniTroubleshoot = null;
        try {
            System.loadLibrary("resin_os");
            _hasJNIReload = ClassEntry.canReloadNative();
            if (!CurrentTime.isTest()) {
                if (_hasJNIReload) {
                    log.config("In-place class redefinition (HotSwap) is available.");
                } else {
                    log.config("In-place class redefinition (HotSwap) is not available.  In-place class reloading during development requires a compatible JDK and -Xdebug.");
                }
            }
            jniTroubleshoot = new JniTroubleshoot(ClassEntry.class, "resin_os");
        }
        catch (Throwable e) {
            jniTroubleshoot = new JniTroubleshoot(ClassEntry.class, "resin_os", e);
        }
        _jniTroubleshoot = jniTroubleshoot;
        _jniTroubleshoot.log();
    }

    class ReloadThread
    implements Runnable {
        private volatile boolean _isDone;

        ReloadThread() {
        }

        public boolean isDone() {
            return this._isDone;
        }

        public void run() {
        }
    }
}

