/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class EnvironmentLogger
extends Logger
implements ClassLoaderListener {
    private static final Handler[] EMPTY_HANDLERS = new Handler[0];
    private static ClassLoader _systemClassLoader;
    private final EnvironmentLocal<Logger> _localLoggers = new EnvironmentLocal();
    private final EnvironmentLocal<Handler[]> _localHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<HandlerEntry> _ownHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<Boolean> _useParentHandlers = new EnvironmentLocal();
    private EnvironmentLocal<Level> _localLevel;
    private Level _systemLevel = null;
    private EnvironmentLogger _parent;
    private final ArrayList<WeakReference<EnvironmentLogger>> _children = new ArrayList();
    private final ArrayList<WeakReference<ClassLoader>> _loaders = new ArrayList();
    private EnvironmentLocal<Integer> _localEffectiveLevel;
    private boolean _hasLocalEffectiveLevel;
    private Level _finestEffectiveLevel = Level.INFO;
    private int _finestEffectiveLevelValue = this._finestEffectiveLevel.intValue();
    private int _systemEffectiveLevelValue = Level.INFO.intValue();

    public EnvironmentLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public void setParent(Logger parent) {
        if (parent.equals(this._parent)) {
            return;
        }
        super.setParent(parent);
        if (parent instanceof EnvironmentLogger) {
            this._parent = (EnvironmentLogger)parent;
            this._parent.addChild(this);
        }
        this.updateEffectiveLevel(_systemClassLoader);
    }

    public Level getLevel() {
        Level level;
        if (this._localLevel != null && (level = this._localLevel.get()) != null) {
            return level;
        }
        return this._systemLevel;
    }

    public void setLevel(Level level) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = _systemClassLoader;
        }
        if (loader != _systemClassLoader) {
            if (this._localLevel == null) {
                this._localLevel = new EnvironmentLocal();
            }
            this._localLevel.set(level);
            if (level != null) {
                this.addLoader(loader);
            }
        } else {
            this._systemLevel = level;
        }
        this.updateEffectiveLevel(loader);
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this._localHandlers.get();
        if (handlers != null) {
            return handlers;
        }
        return EMPTY_HANDLERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        EnvironmentLogger environmentLogger = this;
        synchronized (environmentLogger) {
            HandlerEntry ownHandlers;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = _systemClassLoader;
            }
            boolean hasLoader = false;
            for (int i = this._loaders.size() - 1; i >= 0; --i) {
                WeakReference<ClassLoader> ref = this._loaders.get(i);
                ClassLoader refLoader = (ClassLoader)ref.get();
                if (refLoader == null) {
                    this._loaders.remove(i);
                }
                if (refLoader == loader) {
                    hasLoader = true;
                }
                if (!this.isParentLoader(loader, refLoader)) continue;
                this.addHandler(handler, refLoader);
            }
            if (!hasLoader) {
                this._loaders.add(new WeakReference<ClassLoader>(loader));
                this.addHandler(handler, loader);
                Environment.addClassLoaderListener(this, loader);
            }
            if ((ownHandlers = this._ownHandlers.get()) == null) {
                ownHandlers = new HandlerEntry(this);
                this._ownHandlers.set(ownHandlers);
            }
            ownHandlers.addHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler handler) {
        EnvironmentLogger environmentLogger = this;
        synchronized (environmentLogger) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = _systemClassLoader;
            }
            for (int i = this._loaders.size() - 1; i >= 0; --i) {
                WeakReference<ClassLoader> ref = this._loaders.get(i);
                ClassLoader refLoader = (ClassLoader)ref.get();
                if (refLoader == null) {
                    this._loaders.remove(i);
                }
                if (!this.isParentLoader(loader, refLoader)) continue;
                this.removeHandler(handler, refLoader);
            }
            HandlerEntry ownHandlers = this._ownHandlers.get();
            if (ownHandlers != null) {
                ownHandlers.removeHandler(handler);
            }
        }
    }

    public final boolean isLoggable(Level level) {
        if (level == null) {
            return false;
        }
        int intValue = level.intValue();
        if (intValue < this._finestEffectiveLevelValue) {
            return false;
        }
        if (!this._hasLocalEffectiveLevel) {
            return true;
        }
        Integer localValue = this._localEffectiveLevel.get();
        if (localValue != null) {
            int localIntValue = localValue;
            if (localIntValue == Level.OFF.intValue()) {
                return false;
            }
            return localIntValue <= intValue;
        }
        if (this._systemEffectiveLevelValue == Level.OFF.intValue()) {
            return false;
        }
        return this._systemEffectiveLevelValue <= intValue;
    }

    public boolean getUseParentHandlers() {
        Boolean value = this._useParentHandlers.get();
        if (value != null) {
            return Boolean.TRUE.equals(value);
        }
        return true;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._useParentHandlers.set(new Boolean(useParentHandlers));
    }

    public void log(LogRecord record) {
        if (record == null) {
            return;
        }
        Level recordLevel = record.getLevel();
        if (!this.isLoggable(recordLevel)) {
            return;
        }
        for (Logger ptr = this; ptr != null; ptr = ptr.getParent()) {
            Handler[] handlers = ((Logger)ptr).getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].publish(record);
                }
            }
            if (!((Logger)ptr).getUseParentHandlers()) break;
        }
    }

    void addChild(EnvironmentLogger child) {
        this._children.add(new WeakReference<EnvironmentLogger>(child));
        this.updateChildren();
    }

    private void addHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        handlers.add(handler);
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        if (loader == _systemClassLoader) {
            loader = null;
        }
        this._localHandlers.set(newHandlers, loader);
    }

    private void removeHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                if (localHandlers[i].equals(handler)) continue;
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        this._localHandlers.set(newHandlers, loader);
    }

    private boolean isParentLoader(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    boolean addCustomLogger(Logger logger) {
        if (logger.getClass().getName().startsWith("java")) {
            return false;
        }
        Logger oldLogger = this._localLoggers.get();
        if (oldLogger != null) {
            return false;
        }
        this._localLoggers.set(logger);
        if (this._parent != null) {
            logger.setParent(this._parent);
        }
        return true;
    }

    Logger getLogger() {
        return this._localLoggers.get();
    }

    private void addLoader(ClassLoader loader) {
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (refLoader != loader) continue;
            return;
        }
        this._loaders.add(new WeakReference<ClassLoader>(loader));
        Environment.addClassLoaderListener(this, loader);
    }

    private synchronized void updateEffectiveLevel(ClassLoader loader) {
        Level newEffectiveLevel;
        int oldEffectiveLevel;
        if (loader == null) {
            loader = _systemClassLoader;
        }
        if ((oldEffectiveLevel = this.getEffectiveLevel(loader)) == (newEffectiveLevel = this.calculateEffectiveLevel(loader)).intValue() && loader != _systemClassLoader) {
            return;
        }
        this._finestEffectiveLevel = newEffectiveLevel;
        this._hasLocalEffectiveLevel = false;
        this.updateEffectiveLevelPart(_systemClassLoader);
        this.updateEffectiveLevelPart(loader);
        for (int i = 0; i < this._loaders.size(); ++i) {
            WeakReference<ClassLoader> loaderRef = this._loaders.get(i);
            ClassLoader classLoader = (ClassLoader)loaderRef.get();
            if (classLoader == null) continue;
            this.updateEffectiveLevelPart(classLoader);
        }
        super.setLevel(this._finestEffectiveLevel);
        this._finestEffectiveLevelValue = this._finestEffectiveLevel.intValue();
        this.updateChildren();
    }

    private void updateChildren() {
        this.updateChildren(_systemClassLoader);
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> loaderRef = this._loaders.get(i);
            ClassLoader subLoader = (ClassLoader)loaderRef.get();
            if (subLoader != null) {
                this.updateChildren(subLoader);
                continue;
            }
            this._loaders.remove(i);
        }
    }

    private void updateEffectiveLevelPart(ClassLoader loader) {
        Level level = this.getOwnEffectiveLevel(loader);
        if (loader == _systemClassLoader) {
            int n = this._systemEffectiveLevelValue = level != null ? level.intValue() : Level.INFO.intValue();
        }
        if (level == null) {
            if (this._localEffectiveLevel != null) {
                this._localEffectiveLevel.remove(loader);
            }
            return;
        }
        if (this._finestEffectiveLevel == null) {
            this._finestEffectiveLevel = level;
        } else if (level.intValue() < this._finestEffectiveLevel.intValue()) {
            this._finestEffectiveLevel = level;
        }
        if (loader == _systemClassLoader) {
            this._systemEffectiveLevelValue = level.intValue();
        } else {
            this._hasLocalEffectiveLevel = true;
            this.addLoader(loader);
            if (this._localEffectiveLevel == null) {
                this._localEffectiveLevel = new EnvironmentLocal();
            }
            this._localEffectiveLevel.set(level.intValue(), loader);
        }
    }

    private Level getOwnEffectiveLevel(ClassLoader loader) {
        Level level = null;
        if (loader == _systemClassLoader) {
            level = this._systemLevel;
        } else if (this._localLevel != null) {
            level = this._localLevel.getLevel(loader);
        }
        if (level != null) {
            return level;
        }
        if (this._parent != null) {
            return this._parent.getOwnEffectiveLevel(loader);
        }
        return null;
    }

    private int getEffectiveLevel(ClassLoader loader) {
        Integer intLevel;
        int oldEffectiveLevel = this._systemEffectiveLevelValue;
        if (this._localEffectiveLevel != null && (intLevel = this._localEffectiveLevel.get(loader)) != null) {
            oldEffectiveLevel = intLevel;
        }
        return oldEffectiveLevel;
    }

    private Level calculateEffectiveLevel(ClassLoader loader) {
        Level level = this.getLevel(loader);
        if (level != null) {
            return level;
        }
        if (this._parent != null) {
            return this._parent.calculateEffectiveLevel(loader);
        }
        return Level.INFO;
    }

    private Level getLevel(ClassLoader loader) {
        Level level;
        if (this._localLevel != null && (level = this._localLevel.get(loader)) != null) {
            return level;
        }
        return this._systemLevel;
    }

    private Level getFinestLevel() {
        Level level = this._parent == null ? Level.INFO : (this._parent.isLocalLevel() ? this.selectFinestLevel(this._systemLevel, this._parent.getFinestLevel()) : (this._systemLevel != null ? this._systemLevel : this._parent.getFinestLevel()));
        if (this._localLevel == null) {
            return level;
        }
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader loader = (ClassLoader)ref.get();
            if (loader == null) {
                this._loaders.remove(i);
            }
            level = this.selectFinestLevel(level, this._localLevel.get(loader));
        }
        return level;
    }

    private boolean isLocalLevel() {
        if (this._localLevel != null) {
            return false;
        }
        return this._parent == null || this._parent.isLocalLevel();
    }

    private Level selectFinestLevel(Level a, Level b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b.intValue() < a.intValue()) {
            return b;
        }
        return a;
    }

    private Level getAssignedLevel(ClassLoader loader) {
        Object level = null;
        if (this._localLevel != null) {
            return this._localLevel.get(loader);
        }
        return null;
    }

    private void updateClassLoaderLevel(ClassLoader loader) {
        if (this._localLevel == null) {
            if (this._systemLevel != null) {
                super.setLevel(this._systemLevel);
            }
            return;
        }
        Level localLevel = this._localLevel.get(loader);
        if (localLevel != null) {
            if (!this._hasLocalEffectiveLevel) {
                super.setLevel(localLevel);
            } else if (localLevel.intValue() < super.getLevel().intValue()) {
                super.setLevel(localLevel);
            }
            this._hasLocalEffectiveLevel = true;
        }
    }

    private void updateChildren(ClassLoader loader) {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            WeakReference<EnvironmentLogger> ref = this._children.get(i);
            EnvironmentLogger child = (EnvironmentLogger)ref.get();
            if (child != null) {
                child.updateEffectiveLevel(loader);
                continue;
            }
            this._children.remove(i);
        }
    }

    private synchronized void removeLoader(ClassLoader loader) {
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
                continue;
            }
            if (refLoader != loader) continue;
            this._loaders.remove(i);
        }
    }

    public void classLoaderInit(DynamicClassLoader env) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.removeLoader(loader);
        this._localHandlers.remove(loader);
        HandlerEntry ownHandlers = this._ownHandlers.getLevel(loader);
        if (ownHandlers != null) {
            this._ownHandlers.remove(loader);
        }
        if (ownHandlers != null) {
            ownHandlers.destroy();
        }
        if (this._localLevel != null) {
            this._localLevel.remove(loader);
        }
        this.updateEffectiveLevel(_systemClassLoader);
    }

    public String toString() {
        return "EnvironmentLogger[" + this.getName() + "]";
    }

    static {
        try {
            _systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class HandlerEntry {
        private final EnvironmentLogger _logger;
        private ArrayList<Handler> _handlers = new ArrayList();

        HandlerEntry(EnvironmentLogger logger) {
            this._logger = logger;
        }

        void addHandler(Handler handler) {
            this._handlers.add(handler);
        }

        void removeHandler(Handler handler) {
            this._handlers.remove(handler);
        }

        void destroy() {
            ArrayList<Handler> handlers = this._handlers;
            this._handlers = null;
            for (int i = 0; handlers != null && i < handlers.size(); ++i) {
                Handler handler = handlers.get(i);
                try {
                    handler.close();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

