/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.vfs.InputStreamStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StringPath;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Quercus
extends QuercusContext {
    private static final Logger log = Logger.getLogger(Quercus.class.getName());
    private String _fileName;
    private String[] _argv;

    public static void main(String[] args) throws IOException {
        Quercus quercus = new Quercus();
        Quercus.startMain(args, quercus);
    }

    public static void startMain(String[] args, Quercus quercus) throws IOException {
        if (!quercus.parseArgs(args)) {
            quercus.printUsage();
            return;
        }
        quercus.init();
        quercus.start();
        if (quercus.getFileName() != null) {
            quercus.execute();
        } else {
            InputStream is = System.in;
            ReadStream stream = new ReadStream(new InputStreamStream(is));
            quercus.execute(stream);
        }
    }

    public void printUsage() {
        System.out.println("usage: " + this.getClass().getName() + " [flags] <file> [php-args]");
        System.out.println(" -f            : Explicitly set the script filename.");
        System.out.println(" -d name=value : Sets a php ini value.");
    }

    public String getSapiName() {
        return "cli";
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    protected boolean parseArgs(String[] args) {
        int i;
        ArrayList<String> phpArgList = new ArrayList<String>();
        for (i = 0; i < args.length; ++i) {
            if ("-d".equals(args[i])) {
                String value;
                String name;
                String arg = args[i + 1];
                int eqIndex = arg.indexOf(61);
                if (eqIndex >= 0) {
                    name = arg.substring(0, eqIndex);
                    value = arg.substring(eqIndex + 1);
                } else {
                    name = arg;
                    value = "";
                }
                ++i;
                this.setIni(name, value);
                continue;
            }
            if ("-f".equals(args[i])) {
                this._fileName = args[++i];
                continue;
            }
            if ("-q".equals(args[i]) || "-n".equals(args[i])) continue;
            if ("--".equals(args[i])) break;
            if ("-h".equals(args[i]) || "--help".equals(args[i])) {
                return false;
            }
            if (!args[i].startsWith("-")) break;
            System.out.println("unknown option: " + args[i]);
            return false;
        }
        while (i < args.length) {
            phpArgList.add(args[i]);
            ++i;
        }
        this._argv = phpArgList.toArray(new String[phpArgList.size()]);
        if (this._fileName == null && this._argv.length > 0) {
            this._fileName = this._argv[0];
        }
        return true;
    }

    protected String[] getArgv() {
        return this._argv;
    }

    public void execute() throws IOException {
        Path path = this.getPwd().lookup(this._fileName);
        this.execute(path);
    }

    public void execute(String code) throws IOException {
        StringPath path = new StringPath(code);
        this.execute(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Path path) throws IOException {
        QuercusPage page = this.parse(path);
        WriteStream os = new WriteStream(StdoutStream.create());
        os.setNewlineString("\n");
        os.setEncoding("iso-8859-1");
        Env env = this.createEnv(page, os, null, null);
        env.start();
        try {
            env.execute();
        }
        catch (QuercusDieException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            env.close();
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ReadStream stream) throws IOException {
        QuercusPage page = this.parse(stream);
        WriteStream os = new WriteStream(StdoutStream.create());
        os.setNewlineString("\n");
        os.setEncoding("iso-8859-1");
        Env env = this.createEnv(page, os, null, null);
        env.start();
        try {
            env.execute();
        }
        catch (QuercusDieException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            env.close();
            os.flush();
        }
    }
}

