/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import java.io.IOException;
import java.io.PrintWriter;

public class ArrayValueComponent {
    public static final int MAX_SIZE = 512;
    public static final int MAX_DYNAMIC_SIZE = 1024;
    protected Value[] _keys;
    protected Value[] _values;

    public ArrayValueComponent() {
        this.init();
    }

    public ArrayValueComponent(Value[] keys, Value[] values) {
        this._keys = keys;
        this._values = values;
    }

    public static ArrayValueComponent[] create(ArrayValue array) {
        int size = array.getSize();
        int bins = size / 512;
        if (size % 512 > 0) {
            ++bins;
        }
        ArrayValueComponent[] components = new ArrayValueComponent[bins];
        Value[] keys = array.keysToArray();
        Value[] values = array.valuesToArray();
        for (int bin = 0; bin < bins; ++bin) {
            int binSize = 512;
            if (bin + 1 == bins) {
                binSize = size - bin * 512;
            }
            Value[] k = new Value[binSize];
            Value[] v = new Value[binSize];
            System.arraycopy(keys, bin * 512, k, 0, binSize);
            System.arraycopy(values, bin * 512, v, 0, binSize);
            components[bin] = new ArrayValueComponent(k, v);
        }
        return components;
    }

    public static void generate(PrintWriter out, ArrayValue array) throws IOException {
        int size = array.getSize();
        int bins = size / 512;
        if (size % 512 > 0) {
            ++bins;
        }
        Value[] keys = array.keysToArray();
        Value[] values = array.valuesToArray();
        out.print("new ArrayValueComponent[] {");
        for (int bin = 0; bin < bins; ++bin) {
            int i;
            int binSize = 512;
            if (bin != 0) {
                out.print(", ");
            }
            if (bin + 1 == bins) {
                binSize = size - bin * 512;
            }
            out.println("new ArrayValueComponent() {");
            out.println("    public void init() {");
            out.print("      _keys = new Value[] {");
            for (i = 0; i < binSize; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                keys[i + bin * 512].generate(out);
            }
            out.println("};");
            out.print("      _values = new Value[] {");
            for (i = 0; i < binSize; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                values[i + bin * 512].generate(out);
            }
            out.println("};");
            out.println("    }");
            out.println("  }");
        }
        out.print("}");
    }

    public void init() {
    }

    public void init(Env env) {
    }

    public final void addTo(ArrayValue array) {
        for (int i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] != null) {
                array.append(this._keys[i], this._values[i]);
                continue;
            }
            array.put(this._values[i]);
        }
    }

    public Value[] getKeys() {
        return this._keys;
    }

    public Value[] getValues() {
        return this._values;
    }
}

