/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetValue;
import com.caucho.quercus.env.ArrayCopyValueImpl;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueComponent;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.ConstArrayValue;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.RandomUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayValueImpl
extends ArrayValue
implements Serializable {
    private static final int DEFAULT_SIZE = 16;
    private static final int SORT_REGULAR = 0;
    private static final int SORT_NUMERIC = 1;
    private static final int SORT_STRING = 2;
    private static final int SORT_LOCALE_STRING = 5;
    private static final int MIN_HASH = 4;
    private ArrayValue.Entry[] _entries;
    private int _hashMask;
    private int _size;
    private long _nextAvailableIndex;
    private boolean _isDirty;
    private ArrayValue.Entry _head;
    private ArrayValue.Entry _tail;
    private ConstArrayValue _constSource;

    public ArrayValueImpl() {
    }

    public ArrayValueImpl(int size) {
    }

    public ArrayValueImpl(ArrayValue source) {
        for (ArrayValue.Entry ptr = source.getHead(); ptr != null; ptr = ptr.getNext()) {
            ArrayValue.Entry entry = this.createNewEntry(ptr.getKey());
            entry.setValue(ptr.getValue().copyArrayItem());
        }
    }

    public ArrayValueImpl(ArrayValueImpl source) {
        this.copyFrom(source);
    }

    protected void copyFrom(ArrayValueImpl source) {
        if (!source._isDirty) {
            source._isDirty = true;
        }
        this._isDirty = true;
        this._size = source._size;
        this._entries = source._entries;
        this._hashMask = source._hashMask;
        this._head = source._head;
        this.setCurrent(source.getCurrent());
        this._tail = source._tail;
        this._nextAvailableIndex = source._nextAvailableIndex;
    }

    public ArrayValueImpl(ConstArrayValue source) {
        this._constSource = source;
        this._isDirty = true;
        this._size = source.getSize();
        this._entries = source.getEntries();
        this._hashMask = source.getHashMask();
        this._head = source.getHead();
        this.setCurrent(source.getCurrent());
        this._tail = source.getTail();
        this._nextAvailableIndex = source.getNextAvailableIndex();
    }

    public ArrayValueImpl(Env env, IdentityHashMap<Value, Value> map, ArrayValue copy) {
        this();
        map.put(copy, this);
        for (ArrayValue.Entry ptr = copy.getHead(); ptr != null; ptr = ptr.getNext()) {
            Value value = ptr.toValue();
            this.append(ptr.getKey(), value.copy(env, map));
        }
    }

    protected ArrayValueImpl(Env env, ArrayValue copy, CopyRoot root) {
        this();
        root.putCopy(copy, this);
        for (ArrayValue.Entry ptr = copy.getHead(); ptr != null; ptr = ptr.getNext()) {
            Value value = ptr.toValue();
            this.append(ptr.getKey(), value.copyTree(env, root));
        }
    }

    public ArrayValueImpl(Value[] keys, Value[] values) {
        this();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != null) {
                this.append(keys[i], values[i]);
                continue;
            }
            this.put(values[i]);
        }
    }

    public ArrayValueImpl(Value[] values) {
        this();
        for (int i = 0; i < values.length; ++i) {
            this.put(values[i]);
        }
    }

    public ArrayValueImpl(Env env, ArrayValueComponent[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i].init(env);
            components[i].addTo(this);
        }
    }

    public ArrayValueImpl(ArrayValueComponent[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i].init();
            components[i].addTo(this);
        }
    }

    protected ArrayValue.Entry[] getEntries() {
        return this._entries;
    }

    protected int getHashMask() {
        return this._hashMask;
    }

    protected long getNextAvailableIndex() {
        return this._nextAvailableIndex;
    }

    private void copyOnWrite() {
        if (!this._isDirty) {
            return;
        }
        this._constSource = null;
        this._isDirty = false;
        Object entries = this._entries;
        entries = entries != null ? new ArrayValue.Entry[((ArrayValue.Entry[])entries).length] : null;
        ArrayValue.Entry prev = null;
        for (ArrayValue.Entry ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            ArrayValue.Entry ptrCopy = new ArrayValue.Entry(ptr);
            if (entries != null) {
                int hash = ptr.getKey().hashCode() & this._hashMask;
                ArrayValue.Entry head = entries[hash];
                if (head != null) {
                    ptrCopy.setNextHash(head);
                }
                entries[hash] = ptrCopy;
            } else if (prev != null) {
                prev.setNextHash(ptrCopy);
            }
            if (prev == null) {
                this.setCurrent(ptrCopy);
                this._head = ptrCopy;
            } else {
                prev.setNext(ptrCopy);
                ptrCopy.setPrev(prev);
            }
            prev = ptrCopy;
        }
        this._tail = prev;
        this._entries = entries;
    }

    @Override
    public String getType() {
        return "array";
    }

    @Override
    public boolean toBoolean() {
        return this._size != 0;
    }

    @Override
    public StringValue toString(Env env) {
        return env.createString("Array");
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public Value copy() {
        this.reset();
        ArrayValueImpl copy = new ArrayValueImpl(this);
        return copy;
    }

    @Override
    public Value copyReturn() {
        return new ArrayValueImpl(this);
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return new ArrayValueImpl(env, map, this);
    }

    @Override
    public Value copyTree(Env env, CopyRoot root) {
        Value copy = root.getCopy(this);
        if (copy != null) {
            return copy;
        }
        return new ArrayCopyValueImpl(env, this, root);
    }

    @Override
    public Value copySaveFunArg() {
        return new ArrayValueImpl(this);
    }

    @Override
    public Value toLocalValue() {
        ArrayValueImpl copy = new ArrayValueImpl(this);
        ((Value)copy).reset();
        return copy;
    }

    @Override
    public Value toLocalRef() {
        ArrayValueImpl copy = new ArrayValueImpl(this);
        ((Value)copy).reset();
        return copy;
    }

    @Override
    public Value toRefValue() {
        return this;
    }

    public int size() {
        return this._size;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public void clear() {
        if (this._isDirty) {
            this._isDirty = false;
        }
        this._entries = null;
        this._size = 0;
        this._tail = null;
        this._head = null;
        this.setCurrent(null);
        this._nextAvailableIndex = 0L;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if (key instanceof UnsetValue) {
            key = this.createTailKey();
        }
        ArrayValue.Entry entry = this.createEntry(key);
        entry.set(value);
        return this;
    }

    @Override
    public ArrayValue unshift(Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        ++this._size;
        ArrayValue.Entry[] entries = this._entries;
        if (entries == null && this._size >= 4 || entries != null && entries.length <= 2 * this._size) {
            this.expand();
        }
        Value key = this.createTailKey();
        ArrayValue.Entry entry = new ArrayValue.Entry(key, value.toLocalValue());
        this.addEntry(entry);
        if (this._head != null) {
            this._head._prev = entry;
            entry.setNext(this._head);
            this._head = entry;
        } else {
            this._head = this._tail = entry;
        }
        return this;
    }

    @Override
    public ArrayValue splice(int start, int end, ArrayValue replace) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        int index = 0;
        ArrayValueImpl result = new ArrayValueImpl();
        ArrayValue.Entry ptr = this._head;
        ArrayValue.Entry nextPtr = null;
        while (ptr != null) {
            nextPtr = ptr.getNext();
            Value key = ptr.getKey();
            if (index >= start) {
                if (index < end) {
                    --this._size;
                    ArrayValue.Entry prev = ptr.getPrev();
                    ArrayValue.Entry next = ptr.getNext();
                    if (prev != null) {
                        prev.setNext(next);
                    } else {
                        this._head = next;
                    }
                    if (next != null) {
                        next.setPrev(prev);
                    } else {
                        this._tail = prev;
                    }
                    if (key.isString()) {
                        result.put(key, ptr.getValue());
                    } else {
                        result.put(ptr.getValue());
                    }
                } else {
                    if (replace == null) {
                        return result;
                    }
                    for (ArrayValue.Entry replaceEntry = replace.getHead(); replaceEntry != null; replaceEntry = replaceEntry.getNext()) {
                        ++this._size;
                        ArrayValue.Entry[] entries = this._entries;
                        if (entries == null && this._size >= 4 || entries != null && entries.length <= 2 * this._size) {
                            this.expand();
                        }
                        ArrayValue.Entry entry = new ArrayValue.Entry(this.createTailKey(), replaceEntry.getValue());
                        this.addEntry(entry);
                        ArrayValue.Entry prev = ptr.getPrev();
                        entry.setNext(ptr);
                        entry.setPrev(prev);
                        if (prev != null) {
                            prev.setNext(entry);
                        } else {
                            this._head = entry;
                        }
                        ptr.setPrev(entry);
                    }
                    return result;
                }
            }
            ++index;
            ptr = nextPtr;
        }
        if (replace != null) {
            for (ArrayValue.Entry replaceEntry = replace.getHead(); replaceEntry != null; replaceEntry = replaceEntry.getNext()) {
                this.put(replaceEntry.getValue());
            }
        }
        return result;
    }

    @Override
    public ArrayValue slice(Env env, int start, int end, boolean isPreserveKeys) {
        ArrayValueImpl array = new ArrayValueImpl();
        int i = 0;
        for (ArrayValue.Entry ptr = this._head; i < end && ptr != null; ptr = ptr.getNext()) {
            if (start > i++) continue;
            Value key = ptr.getKey();
            Value value = ptr.getValue();
            if (isPreserveKeys || key.isString()) {
                array.put(key, value);
                continue;
            }
            array.put(value);
        }
        return array;
    }

    @Override
    public Value getArg(Value index, boolean isTop) {
        ArrayValue.Entry entry;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((entry = this.getEntry(index)) != null) {
            Value value = entry.getValue();
            if (!isTop && value.isset()) {
                return value;
            }
            return new ArgGetValue(this, index);
        }
        return new ArgGetValue(this, index);
    }

    @Override
    public Value getObject(Env env, Value fieldName) {
        Value value = this.get(fieldName);
        if (!value.isset()) {
            value = env.createObject();
            this.put(fieldName, value);
        }
        return value;
    }

    @Override
    public Value getArray(Value index) {
        Value array;
        ArrayValue.Entry entry;
        Value value;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((value = (entry = this.createEntry(index)).toValue()) != (array = value.toAutoArray())) {
            value = array;
            entry.set(array);
            return array;
        }
        if (array.isString()) {
            return entry.toRef();
        }
        return array;
    }

    @Override
    public Value getDirty(Value index) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        return this.get(index);
    }

    @Override
    public Value put(Value value) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        Value key = this.createTailKey();
        this.append(key, value);
        return value;
    }

    @Override
    public Var putVar() {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        Value tailKey = this.createTailKey();
        return this.getVar(tailKey);
    }

    @Override
    public Value getArgTail(Env env, boolean isTop) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        Value tail = this.createTailKey();
        return new ArgGetValue(this, tail);
    }

    @Override
    public Value createTailKey() {
        if (this._nextAvailableIndex < 0L) {
            this.updateNextAvailableIndex();
        }
        return LongValue.create(this._nextAvailableIndex);
    }

    @Override
    public Value get(Value key) {
        ArrayValue.Entry entry;
        key = key.toKey();
        ArrayValue.Entry[] entries = this._entries;
        if (entries != null) {
            int hash = key.hashCode() & this._hashMask;
            entry = entries[hash];
        } else {
            entry = this._head;
        }
        while (entry != null) {
            Value entryKey = entry.getKey();
            if (key == entryKey || key.equals(entryKey)) {
                return entry.toValue();
            }
            entry = entry.getNextHash();
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value getRaw(Value key) {
        ArrayValue.Entry entry;
        key = key.toKey();
        ArrayValue.Entry[] entries = this._entries;
        if (entries != null) {
            int hashMask = this._hashMask;
            int hash = key.hashCode() & hashMask;
            entry = entries[hash];
        } else {
            entry = this._head;
        }
        while (entry != null) {
            Value entryKey = entry.getKey();
            if (key == entryKey || key.equals(entryKey)) {
                return entry.getRawValue();
            }
            entry = entry.getNextHash();
        }
        return UnsetValue.UNSET;
    }

    @Override
    public Value contains(Value value) {
        for (ArrayValue.Entry entry = this.getHead(); entry != null; entry = entry.getNext()) {
            if (!entry.getValue().eq(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value containsStrict(Value value) {
        for (ArrayValue.Entry entry = this.getHead(); entry != null; entry = entry.getNext()) {
            if (!entry.getValue().eql(value)) continue;
            return entry.getKey();
        }
        return NullValue.NULL;
    }

    @Override
    public Value containsKey(Value key) {
        ArrayValue.Entry entry = this.getEntry(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    private ArrayValue.Entry getEntry(Value key) {
        ArrayValue.Entry entry;
        key = key.toKey();
        ArrayValue.Entry[] entries = this._entries;
        if (entries != null) {
            int hash = key.hashCode() & this._hashMask;
            entry = entries[hash];
        } else {
            entry = this._head;
        }
        while (entry != null) {
            Value entryKey = entry.getKey();
            if (key == entryKey || key.equals(entryKey)) {
                return entry;
            }
            entry = entry.getNextHash();
        }
        return null;
    }

    @Override
    public Value remove(Value key) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        key = key.toKey();
        ArrayValue.Entry[] entries = this._entries;
        int hash = key.hashCode() & this._hashMask;
        ArrayValue.Entry prevHash = null;
        for (ArrayValue.Entry entry = entries != null ? entries[hash] : this._head; entry != null; entry = entry.getNextHash()) {
            Value entryKey = entry.getKey();
            if (key == entryKey || key.equals(entryKey)) {
                if (prevHash != null) {
                    prevHash.setNextHash(entry.getNextHash());
                } else if (entries != null) {
                    entries[hash] = entry.getNextHash();
                } else {
                    this._head = entry.getNextHash();
                }
                return this.removeEntry(key, entry);
            }
            prevHash = entry;
        }
        return UnsetValue.UNSET;
    }

    private Value removeEntry(Value key, ArrayValue.Entry entry) {
        ArrayValue.Entry next = entry.getNext();
        ArrayValue.Entry prev = entry.getPrev();
        if (prev != null) {
            prev.setNext(next);
        } else {
            this._head = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else {
            this._tail = prev;
        }
        entry.setPrev(null);
        entry.setNext(null);
        this.setCurrent(this._head);
        --this._size;
        Value value = entry.getValue();
        if (key.nextIndex(-1L) == this._nextAvailableIndex) {
            this._nextAvailableIndex = -1L;
        }
        return value;
    }

    @Override
    public Var getVar(Value index) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        ArrayValue.Entry entry = this.createEntry(index);
        return entry.toVar();
    }

    @Override
    public Var getRef(Value index) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        ArrayValue.Entry entry = this.createEntry(index);
        return entry.toVar();
    }

    private ArrayValue.Entry createEntry(Value key) {
        key = key.toKey();
        int hash = key.hashCode();
        int hashMask = this._hashMask;
        for (ArrayValue.Entry entry = (entries = this._entries) != null ? entries[hash &= hashMask] : this._head; entry != null; entry = entry.getNextHash()) {
            Value entryKey = entry.getKey();
            if (key == entryKey) {
                return entry;
            }
            if (!key.equals(entryKey)) continue;
            return entry;
        }
        ++this._size;
        ArrayValue.Entry newEntry = new ArrayValue.Entry(key);
        if (this._nextAvailableIndex >= 0L) {
            this._nextAvailableIndex = key.nextIndex(this._nextAvailableIndex);
        }
        if (this._entries == null && this._size < 4) {
            if (this._tail != null) {
                this._tail.setNextHash(newEntry);
            }
        } else {
            if (this._entries == null || this._entries.length <= 2 * this._size) {
                this.expand();
                hash = key.hashCode() & this._hashMask;
            }
            ArrayValue.Entry head = this._entries[hash];
            newEntry.setNextHash(head);
            this._entries[hash] = newEntry;
        }
        if (this._head == null) {
            newEntry.setPrev(null);
            newEntry.setNext(null);
            this._head = newEntry;
            this._tail = newEntry;
            this.setCurrent(newEntry);
        } else {
            newEntry.setPrev(this._tail);
            newEntry.setNext(null);
            this._tail.setNext(newEntry);
            this._tail = newEntry;
        }
        return newEntry;
    }

    private ArrayValue.Entry createNewEntry(Value key) {
        key = key.toKey();
        int hashMask = this._hashMask;
        int hash = key.hashCode() & hashMask;
        ++this._size;
        ArrayValue.Entry newEntry = new ArrayValue.Entry(key);
        if (this._nextAvailableIndex >= 0L) {
            this._nextAvailableIndex = key.nextIndex(this._nextAvailableIndex);
        }
        if (this._entries == null && this._size < 4) {
            if (this._tail != null) {
                this._tail.setNextHash(newEntry);
            }
        } else {
            if (this._entries == null || this._entries.length <= 2 * this._size) {
                this.expand();
                hash = key.hashCode() & this._hashMask;
            }
            ArrayValue.Entry head = this._entries[hash];
            newEntry.setNextHash(head);
            this._entries[hash] = newEntry;
        }
        if (this._head == null) {
            newEntry._prev = null;
            newEntry.setNext(null);
            this._head = newEntry;
            this._tail = newEntry;
            this.setCurrent(newEntry);
        } else {
            newEntry._prev = this._tail;
            newEntry.setNext(null);
            this._tail.setNext(newEntry);
            this._tail = newEntry;
        }
        return newEntry;
    }

    private void expand() {
        ArrayValue.Entry[] entries = this._entries;
        this._entries = entries == null ? new ArrayValue.Entry[8] : new ArrayValue.Entry[2 * entries.length];
        this._hashMask = this._entries.length - 1;
        for (ArrayValue.Entry entry = this._head; entry != null; entry = entry.getNext()) {
            this.addEntry(entry);
        }
    }

    private void addEntry(ArrayValue.Entry entry) {
        Value key = entry.getKey();
        ArrayValue.Entry[] entries = this._entries;
        if (entries != null) {
            int hash = key.hashCode() & this._hashMask;
            ArrayValue.Entry head = entries[hash];
            entry.setNextHash(head);
            entries[hash] = entry;
        }
        if (this._nextAvailableIndex >= 0L) {
            this._nextAvailableIndex = key.nextIndex(this._nextAvailableIndex);
        }
    }

    private void updateNextAvailableIndex() {
        this._nextAvailableIndex = 0L;
        for (ArrayValue.Entry entry = this._head; entry != null; entry = entry.getNext()) {
            this._nextAvailableIndex = entry.getKey().nextIndex(this._nextAvailableIndex);
        }
    }

    @Override
    public Value pop(Env env) {
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if (this._tail != null) {
            return this.remove(this._tail.getKey());
        }
        return NullValue.NULL;
    }

    @Override
    public final ArrayValue.Entry getHead() {
        return this._head;
    }

    @Override
    protected final ArrayValue.Entry getTail() {
        return this._tail;
    }

    @Override
    public Value shuffle() {
        ArrayValue.Entry[] values;
        int length;
        if (this._isDirty) {
            this.copyOnWrite();
        }
        if ((length = (values = new ArrayValue.Entry[this.size()]).length) == 0) {
            return BooleanValue.TRUE;
        }
        int i = 0;
        for (ArrayValue.Entry ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            values[i++] = ptr;
        }
        for (i = 0; i < length; ++i) {
            int rand = RandomUtil.nextInt(length);
            ArrayValue.Entry temp = values[rand];
            values[rand] = values[i];
            values[i] = temp;
        }
        this._head = values[0];
        this._head._prev = null;
        this._tail = values[values.length - 1];
        this._tail.setNext(null);
        for (i = 0; i < length; ++i) {
            if (i > 0) {
                values[i]._prev = values[i - 1];
            }
            if (i >= length - 1) continue;
            values[i].setNext(values[i + 1]);
        }
        this.setCurrent(this._head);
        return BooleanValue.TRUE;
    }

    @Override
    public Value getKeys() {
        if (this._constSource != null) {
            return this._constSource.getKeys();
        }
        return super.getKeys();
    }

    @Override
    public Value getValues() {
        if (this._constSource != null) {
            return this._constSource.getValues();
        }
        return super.getValues();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._size);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        int capacity;
        int size = in.readInt();
        for (capacity = 16; capacity < 4 * size; capacity *= 2) {
        }
        this._entries = new ArrayValue.Entry[capacity];
        this._hashMask = this._entries.length - 1;
        for (int i = 0; i < size; ++i) {
            this.put((Value)in.readObject(), (Value)in.readObject());
        }
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        out.print("new ConstArrayValue(");
        if (this.getSize() < 512) {
            ArrayValue.Entry entry;
            out.print("new Value[] {");
            for (entry = this.getHead(); entry != null; entry = entry.getNext()) {
                if (entry != this.getHead()) {
                    out.print(", ");
                }
                if (entry.getKey() != null) {
                    entry.getKey().generate(out);
                    continue;
                }
                out.print("null");
            }
            out.print("}, new Value[] {");
            for (entry = this.getHead(); entry != null; entry = entry.getNext()) {
                if (entry != this.getHead()) {
                    out.print(", ");
                }
                entry.getValue().generate(out);
            }
            out.print("}");
        } else {
            ArrayValueComponent.generate(out, this);
        }
        out.print(")");
    }
}

