/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.util.IntMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyStaticMap
extends AbstractMap<StringValue, Var> {
    private final IntMap _intMap;
    private final Value[] _values;
    private HashMap<StringValue, Var> _extMap = new HashMap();

    public LazyStaticMap(IntMap intMap, Value[] values) {
        this._intMap = intMap;
        this._values = values;
    }

    @Override
    public Var get(Object key) {
        return this.get((StringValue)key);
    }

    public Var get(StringValue key) {
        int id;
        Var var = this._extMap.get(key);
        if (var == null && (id = this._intMap.get(key)) >= 0 && this._values[id] != null) {
            var = new Var();
            this._extMap.put(key, var);
            Env env = Env.getCurrent();
            Value value = this._values[id].copy(env);
            var.set(value);
        }
        return var;
    }

    @Override
    public Var put(StringValue key, Var newVar) {
        return this._extMap.put(key, newVar);
    }

    @Override
    public Set<Map.Entry<StringValue, Var>> entrySet() {
        return this._extMap.entrySet();
    }
}

